-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Sep 08, 2025 at 05:39 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `arriverrdb2`
--

-- --------------------------------------------------------

--
-- Table structure for table `banners`
--

CREATE TABLE `banners` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `image` varchar(255) NOT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  `button_link` varchar(255) DEFAULT NULL,
  `position` enum('hero','promo_left','promo_right') NOT NULL DEFAULT 'hero',
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `banners`
--

INSERT INTO `banners` (`id`, `title`, `subtitle`, `description`, `image`, `button_text`, `button_link`, `position`, `sort_order`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Edition By Punjab', 'Where Tradition Meets Modern Fashion', NULL, 'banners/vi4gwzeThsmBfwfeXbnUgBnET8T8RwEy5B0nnJn9.jpg', 'New Collection', '/shop', 'hero', 0, 1, '2025-08-26 01:28:02', '2025-08-26 01:28:02'),
(2, 'Define Your Style', 'Premium Streetwear Meets Cultural Heritage', NULL, 'banners/mvwpiftTj3oWYp2Rbo9yX8FhVSwoIR6KVdOIypFk.jpg', 'SHOP NOW', '/shop', 'hero', 1, 1, '2025-08-26 01:30:40', '2025-08-26 01:30:40');

-- --------------------------------------------------------

--
-- Table structure for table `blogs`
--

CREATE TABLE `blogs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `excerpt` text NOT NULL,
  `content` longtext NOT NULL,
  `featured_image` varchar(255) DEFAULT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keywords` text DEFAULT NULL,
  `author` varchar(255) NOT NULL DEFAULT 'Edition By Punjab',
  `read_time` int(11) NOT NULL DEFAULT 5,
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`tags`)),
  `is_published` tinyint(1) NOT NULL DEFAULT 0,
  `is_featured` tinyint(1) NOT NULL DEFAULT 0,
  `published_at` timestamp NULL DEFAULT NULL,
  `views` bigint(20) UNSIGNED NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `blogs`
--

INSERT INTO `blogs` (`id`, `title`, `slug`, `excerpt`, `content`, `featured_image`, `meta_title`, `meta_description`, `meta_keywords`, `author`, `read_time`, `tags`, `is_published`, `is_featured`, `published_at`, `views`, `created_at`, `updated_at`) VALUES
(1, 'Australian Streetwear Trends 2024: The Ultimate Style Guide', 'australian-streetwear-trends-2024-style-guide', 'Discover the hottest streetwear trends taking over Australia in 2024, from cultural fusion fashion to sustainable streetwear choices that define modern style.', '<h2>Australian Streetwear Scene: What\'s Hot in 2024</h2>\n\n<p>Australia\'s streetwear scene is experiencing a cultural renaissance in 2024, blending global influences with distinctly Australian and multicultural elements. From Melbourne\'s creative laneways to Sydney\'s urban beaches, streetwear has become the uniform of self-expression for a generation that values authenticity, comfort, and cultural identity.</p>\n\n<h3>The Rise of Cultural Fusion Streetwear</h3>\n\n<p>One of the most significant trends defining Australian streetwear in 2024 is the fusion of traditional cultural elements with contemporary urban design. Brands like <strong>Edition By Punjab</strong> are leading this movement, seamlessly blending Punjabi heritage with modern streetwear aesthetics.</p>\n\n<div style=\"background: #f8f9fa; padding: 2rem; margin: 2rem 0; border-left: 4px solid #007bff;\">\n    <h4>🔥 Trending Now: Heritage-Inspired Graphics</h4>\n    <ul>\n        <li><strong>Traditional motifs</strong> reimagined for modern silhouettes</li>\n        <li><strong>Cultural typography</strong> mixed with contemporary fonts</li>\n        <li><strong>Color palettes</strong> inspired by traditional textiles</li>\n        <li><strong>Symbolic elements</strong> that tell cultural stories</li>\n    </ul>\n</div>\n\n<h3>Key Streetwear Trends Dominating Australia 2024</h3>\n\n<h4>1. Oversized Comfort Meets Tailored Details</h4>\n\n<p>The oversized trend continues to dominate, but with a twist - strategic tailoring details that elevate the look beyond casual comfort.</p>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #28a745; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Item</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Trend Update 2024</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Styling Tip</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Hoodies</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Cropped lengths, contrast stitching</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Layer over fitted tees</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>T-Shirts</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Heavy-weight cotton, boxy cuts</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Tuck into high-waisted bottoms</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Cargo Pants</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Technical fabrics, tapered legs</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Balance with fitted tops</td>\n        </tr>\n    </tbody>\n</table>\n\n<h4>2. Sustainable Streetwear Movement</h4>\n\n<p>Australian consumers are increasingly conscious about their fashion choices, driving demand for sustainable streetwear options:</p>\n\n<ul>\n    <li><strong>Organic Cotton:</strong> Premium feel with environmental benefits</li>\n    <li><strong>Recycled Materials:</strong> Innovation meets responsibility</li>\n    <li><strong>Local Production:</strong> Supporting Australian manufacturing</li>\n    <li><strong>Quality Over Quantity:</strong> Investment pieces that last</li>\n</ul>\n\n<h4>3. Tech-Wear Influence</h4>\n\n<p>The boundary between streetwear and technical clothing continues to blur, with functional elements becoming fashion statements:</p>\n\n<div style=\"background: #e9ecef; padding: 1.5rem; margin: 2rem 0; border-radius: 0.5rem;\">\n    <h5>Technical Features in Modern Streetwear:</h5>\n    <ul>\n        <li><strong>Reflective details</strong> for urban night visibility</li>\n        <li><strong>Water-resistant fabrics</strong> for unpredictable weather</li>\n        <li><strong>Multi-pocket designs</strong> for modern lifestyle needs</li>\n        <li><strong>Adjustable elements</strong> for customizable fits</li>\n    </ul>\n</div>\n\n<h3>Color Trends Defining 2024 Streetwear</h3>\n\n<h4>Earthy Neutrals with Bold Accents</h4>\n\n<p>The color palette for 2024 streetwear reflects a desire for grounding and authenticity, while still allowing for personal expression:</p>\n\n<ul>\n    <li><strong>Base Colors:</strong> Sand, olive, charcoal, cream</li>\n    <li><strong>Accent Colors:</strong> Rust orange, deep purple, electric blue</li>\n    <li><strong>Metallic Touches:</strong> Bronze, copper, matte gold</li>\n</ul>\n\n<blockquote style=\"background: #fff3cd; padding: 1.5rem; margin: 2rem 0; border-left: 4px solid #856404; font-style: italic;\">\n\"Color in streetwear isn\'t just about aesthetics - it\'s about cultural expression and personal identity. We\'re seeing people use color to tell their stories and connect with their heritage.\" - Fashion Stylist, Melbourne\n</blockquote>\n\n<h3>Australian Cities: Regional Streetwear Differences</h3>\n\n<h4>Melbourne: Creative and Eclectic</h4>\n<ul>\n    <li><strong>Layering:</strong> Complex, artistic layering due to variable weather</li>\n    <li><strong>Vintage Mix:</strong> Thrifted pieces combined with contemporary items</li>\n    <li><strong>Art Influence:</strong> Graphics inspired by street art and gallery culture</li>\n    <li><strong>Gender Fluidity:</strong> Breaking traditional fashion boundaries</li>\n</ul>\n\n<h4>Sydney: Coastal Urban</h4>\n<ul>\n    <li><strong>Beach Influence:</strong> Relaxed fits with surf-inspired elements</li>\n    <li><strong>Minimal Palette:</strong> Clean whites, navy, and natural tones</li>\n    <li><strong>Premium Basics:</strong> Investment in high-quality staples</li>\n    <li><strong>Lifestyle Focus:</strong> Pieces that transition from beach to city</li>\n</ul>\n\n<h4>Brisbane: Tropical Streetwear</h4>\n<ul>\n    <li><strong>Breathable Fabrics:</strong> Linen blends and cotton mesh</li>\n    <li><strong>Bright Accents:</strong> Tropical-inspired pops of color</li>\n    <li><strong>Lightweight Layers:</strong> Sun protection meets style</li>\n</ul>\n\n<h3>The Influence of Social Media on Australian Streetwear</h3>\n\n<p>Social media platforms are shaping how Australians discover and engage with streetwear trends:</p>\n\n<h4>Instagram: Visual Inspiration</h4>\n<ul>\n    <li><strong>Outfit grids</strong> showcasing complete looks</li>\n    <li><strong>Process videos</strong> of styling and customization</li>\n    <li><strong>Brand storytelling</strong> through visual narratives</li>\n</ul>\n\n<h4>TikTok: Trend Acceleration</h4>\n<ul>\n    <li><strong>Styling challenges</strong> that go viral</li>\n    <li><strong>Brand reactions</strong> to trending sounds and challenges</li>\n    <li><strong>Educational content</strong> about fashion history and culture</li>\n</ul>\n\n<h3>Shopping Streetwear in Australia: What to Look For</h3>\n\n<div style=\"background: #d4edda; border: 1px solid #c3e6cb; padding: 1.5rem; margin: 2rem 0; border-radius: 0.375rem;\">\n    <h4 style=\"color: #155724;\">💡 Smart Shopping Tips</h4>\n    <ul>\n        <li><strong>Quality Indicators:</strong> Check stitching, fabric weight, and hardware</li>\n        <li><strong>Fit First:</strong> Oversized doesn\'t mean shapeless</li>\n        <li><strong>Versatility:</strong> Choose pieces that work with multiple outfits</li>\n        <li><strong>Brand Ethics:</strong> Research the brand\'s values and practices</li>\n    </ul>\n</div>\n\n<h3>Upcoming Trends to Watch</h3>\n\n<h4>Late 2024 and Beyond</h4>\n\n<p><strong>Digital Integration:</strong> QR codes and NFC chips embedded in garments for authenticity and storytelling.</p>\n\n<p><strong>Customization Culture:</strong> Brands offering personalization options, from embroidery to removable patches.</p>\n\n<p><strong>Climate-Responsive Design:</strong> Fabrics that adapt to temperature changes and weather conditions.</p>\n\n<p><strong>Community Collaboration:</strong> Brands co-creating with their communities for truly representative designs.</p>\n\n<h3>Building Your 2024 Streetwear Style</h3>\n\n<h4>Start with the Essentials</h4>\n<ol>\n    <li><strong>Quality Hoodie:</strong> Your foundation piece for layering</li>\n    <li><strong>Versatile Tees:</strong> Both fitted and oversized options</li>\n    <li><strong>Statement Outerwear:</strong> Jacket or overshirt with personality</li>\n    <li><strong>Comfortable Bottoms:</strong> Joggers, jeans, or cargo pants</li>\n    <li><strong>Signature Accessories:</strong> Pieces that reflect your identity</li>\n</ol>\n\n<h4>Express Your Identity</h4>\n<ul>\n    <li><strong>Cultural Elements:</strong> Incorporate your heritage respectfully</li>\n    <li><strong>Personal Interests:</strong> Let your hobbies and passions show</li>\n    <li><strong>Values:</strong> Support brands that align with your beliefs</li>\n    <li><strong>Creativity:</strong> Don\'t be afraid to mix unexpected elements</li>\n</ul>\n\n<h3>The Future of Australian Streetwear</h3>\n\n<p>As we move through 2024, Australian streetwear continues to evolve as a powerful form of cultural expression. The fusion of global influences with local identity, combined with increasing consciousness about sustainability and authenticity, is creating a uniquely Australian streetwear culture.</p>\n\n<p>Brands like Edition By Punjab are at the forefront of this movement, demonstrating that streetwear can be both deeply personal and universally appealing. The key is finding pieces that resonate with your story while contributing to the larger narrative of Australian street culture.</p>\n\n<p>Whether you\'re new to streetwear or looking to refresh your style, 2024 offers incredible opportunities to express yourself authentically through fashion. The trends are there to inspire, not dictate - use them as starting points to create looks that are uniquely you.</p>', NULL, 'Australian Streetwear Trends 2024 | Ultimate Style Guide | Edition By Punjab', 'Explore the latest Australian streetwear trends for 2024. Cultural fusion fashion, sustainable choices, and street style inspiration from Edition By Punjab.', 'australian streetwear, streetwear trends 2024, cultural fashion australia, streetwear style guide, modern streetwear', 'Edition By Punjab', 8, '[\"Streetwear Trends\",\"Australian Fashion\",\"Style Guide\",\"Cultural Fashion\",\"2024 Trends\"]', 1, 1, '2025-09-04 16:13:56', 885, '2025-09-05 16:13:56', '2025-09-05 16:13:56'),
(2, 'Cultural Fusion Fashion: How Punjabi Heritage Meets Modern Streetwear', 'cultural-fusion-fashion-punjabi-heritage-modern-streetwear', 'Explore how traditional Punjabi elements are revolutionizing contemporary streetwear fashion in Australia, creating unique cultural fusion pieces.', '<h2>Where Tradition Meets Modern Fashion: The Cultural Fusion Revolution</h2>\n\n<p>In the bustling streets of Australia\'s multicultural cities, a fashion revolution is quietly taking place. Cultural fusion streetwear is redefining what it means to honor heritage while embracing contemporary style, creating a new language of fashion that speaks to identity, belonging, and creative expression.</p>\n\n<h3>Understanding Cultural Fusion in Fashion</h3>\n\n<p>Cultural fusion in streetwear goes beyond simply adding traditional elements to modern clothing. It\'s about creating a meaningful dialogue between past and present, honoring ancestral wisdom while speaking to contemporary experiences.</p>\n\n<div style=\"background: #fff3cd; border: 1px solid #ffeaa7; padding: 1.5rem; margin: 2rem 0; border-radius: 0.375rem;\">\n    <h4 style=\"color: #856404;\">🎨 What Makes Cultural Fusion Authentic?</h4>\n    <ul>\n        <li><strong>Respectful Integration:</strong> Understanding the cultural significance of elements</li>\n        <li><strong>Personal Connection:</strong> Drawing from one\'s own heritage and experiences</li>\n        <li><strong>Contemporary Relevance:</strong> Making traditional elements speak to modern life</li>\n        <li><strong>Quality Craftsmanship:</strong> Honoring traditions through excellent execution</li>\n    </ul>\n</div>\n\n<h3>The Punjabi Influence on Modern Streetwear</h3>\n\n<p>Punjabi culture, with its rich textile traditions, vibrant colors, and strong sense of community, offers incredible inspiration for contemporary streetwear design. Edition By Punjab exemplifies how these elements can be thoughtfully integrated into modern fashion.</p>\n\n<h4>Traditional Elements Reimagined</h4>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #dc3545; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Traditional Element</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Cultural Significance</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Modern Application</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Phulkari Embroidery</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Floral patterns representing joy and prosperity</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Minimalist interpretations on hoodies and tees</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Turban Colors</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Each color holds spiritual meaning</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Color-blocking and gradient techniques</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Gurmukhi Script</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Sacred alphabet of Punjabi language</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Typography elements in contemporary layouts</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Khadi Fabric</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Hand-spun cloth symbolizing self-reliance</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Sustainable fabric choices and textures</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3>The Art of Respectful Cultural Expression</h3>\n\n<p>Creating authentic cultural fusion fashion requires understanding the difference between appreciation and appropriation. Here\'s how to navigate this thoughtfully:</p>\n\n<h4>Cultural Appreciation vs. Appropriation</h4>\n\n<div style=\"background: #d4edda; border: 1px solid #c3e6cb; padding: 1.5rem; margin: 2rem 0; border-radius: 0.375rem;\">\n    <h5 style=\"color: #155724;\">✅ Cultural Appreciation Includes:</h5>\n    <ul>\n        <li>Learning about the cultural context and significance</li>\n        <li>Supporting brands owned by people from that culture</li>\n        <li>Understanding the stories behind traditional elements</li>\n        <li>Using cultural elements to bridge communities</li>\n    </ul>\n</div>\n\n<div style=\"background: #f8d7da; border: 1px solid #f5c6cb; padding: 1.5rem; margin: 2rem 0; border-radius: 0.375rem;\">\n    <h5 style=\"color: #721c24;\">❌ Cultural Appropriation Involves:</h5>\n    <ul>\n        <li>Using sacred or ceremonial elements as fashion</li>\n        <li>Ignoring the cultural significance of symbols</li>\n        <li>Profiting from culture without giving back to the community</li>\n        <li>Stereotyping or misrepresenting cultural elements</li>\n    </ul>\n</div>\n\n<h3>Global Influences on Australian Street Culture</h3>\n\n<p>Australia\'s multicultural landscape creates unique opportunities for cultural fusion in streetwear. Different communities contribute their own aesthetic languages to the broader streetwear conversation.</p>\n\n<h4>Asian Influences</h4>\n<ul>\n    <li><strong>Japanese Minimalism:</strong> Clean lines, quality construction, attention to detail</li>\n    <li><strong>Korean Pop Culture:</strong> Playful graphics, bold colors, youth-oriented designs</li>\n    <li><strong>Chinese Symbolism:</strong> Dragon motifs, luck symbols, traditional color combinations</li>\n</ul>\n\n<h4>Middle Eastern and African Influences</h4>\n<ul>\n    <li><strong>Islamic Geometry:</strong> Complex patterns and mathematical precision</li>\n    <li><strong>African Textiles:</strong> Vibrant prints, storytelling through fabric</li>\n    <li><strong>Calligraphy:</strong> Arabic and other scripts as design elements</li>\n</ul>\n\n<h4>Pacific Islander Influences</h4>\n<ul>\n    <li><strong>Traditional Tattoo Patterns:</strong> Polynesian and Melanesian motifs</li>\n    <li><strong>Natural Dyes:</strong> Earth-toned color palettes</li>\n    <li><strong>Ocean-Inspired Designs:</strong> Wave patterns and maritime themes</li>\n</ul>\n\n<h3>Creating Your Own Cultural Fusion Style</h3>\n\n<h4>Start with Personal Connection</h4>\n\n<p>The most authentic cultural fusion comes from personal experience and heritage. Consider these approaches:</p>\n\n<ol>\n    <li><strong>Research Your Roots:</strong> Learn about your family\'s cultural background</li>\n    <li><strong>Talk to Elders:</strong> Understand the stories behind traditional elements</li>\n    <li><strong>Visit Cultural Centers:</strong> Immerse yourself in community spaces</li>\n    <li><strong>Support Cultural Artists:</strong> Buy from creators who share your heritage</li>\n</ol>\n\n<h4>Building a Fusion Wardrobe</h4>\n\n<div style=\"background: #e9ecef; padding: 1.5rem; margin: 2rem 0; border-left: 4px solid #6c757d;\">\n    <h5>Foundation Pieces for Cultural Fusion Style:</h5>\n    <ul>\n        <li><strong>Statement Hoodie:</strong> With subtle cultural graphics or text</li>\n        <li><strong>Heritage-Inspired Tee:</strong> Featuring traditional patterns or colors</li>\n        <li><strong>Cultural Color Palette:</strong> Build around traditional color combinations</li>\n        <li><strong>Meaningful Accessories:</strong> Jewelry or items with cultural significance</li>\n        <li><strong>Traditional Footwear:</strong> Modern interpretations of classic styles</li>\n    </ul>\n</div>\n\n<h3>The Role of Community in Cultural Fashion</h3>\n\n<p>Cultural fusion streetwear is most powerful when it builds bridges between communities and generations. Fashion becomes a way to:</p>\n\n<ul>\n    <li><strong>Share Stories:</strong> Each piece tells a cultural narrative</li>\n    <li><strong>Build Pride:</strong> Wearing heritage creates confidence and connection</li>\n    <li><strong>Educate Others:</strong> Fashion as a conversation starter about culture</li>\n    <li><strong>Preserve Traditions:</strong> Keeping cultural elements alive in modern contexts</li>\n</ul>\n\n<blockquote style=\"background: #e9ecef; padding: 1.5rem; margin: 2rem 0; font-style: italic; border-left: 4px solid #6c757d;\">\n\"When I wear cultural fusion pieces, I\'m not just wearing clothes - I\'m carrying my ancestors\' stories and sharing them with the world. It\'s a way to honor where I came from while showing where I\'m going.\" - Cultural Fashion Enthusiast, Melbourne\n</blockquote>\n\n<h3>Styling Cultural Fusion Pieces</h3>\n\n<h4>Balanced Integration</h4>\n\n<p>The key to successful cultural fusion styling is balance. Here\'s how to integrate cultural elements without overwhelming your look:</p>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #007bff; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Approach</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Method</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Example</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Subtle Integration</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Small cultural details</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Traditional colors in modern silhouettes</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Statement Piece</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">One bold cultural element</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Heritage graphic hoodie with minimal styling</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Full Integration</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Multiple cultural elements</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Traditional patterns, colors, and accessories</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3>Supporting Authentic Cultural Fashion Brands</h3>\n\n<p>When building a cultural fusion wardrobe, supporting authentic brands makes a difference:</p>\n\n<h4>What to Look for in Cultural Fashion Brands:</h4>\n<ul>\n    <li><strong>Cultural Ownership:</strong> Brands owned by people from the culture they represent</li>\n    <li><strong>Community Involvement:</strong> Brands that give back to their communities</li>\n    <li><strong>Educational Content:</strong> Brands that share the stories behind their designs</li>\n    <li><strong>Quality Commitment:</strong> Brands that honor traditions through craftsmanship</li>\n</ul>\n\n<h3>The Future of Cultural Fusion Fashion</h3>\n\n<p>As Australia continues to embrace its multicultural identity, cultural fusion fashion will play an increasingly important role in how we express ourselves and connect with others.</p>\n\n<h4>Emerging Trends in Cultural Fusion:</h4>\n<ul>\n    <li><strong>Collaborative Designs:</strong> Different cultures working together on pieces</li>\n    <li><strong>Digital Storytelling:</strong> QR codes linking to cultural stories and history</li>\n    <li><strong>Sustainable Practices:</strong> Using traditional, eco-friendly methods</li>\n    <li><strong>Global Community:</strong> Connecting cultural diaspora communities worldwide</li>\n</ul>\n\n<h3>Conclusion: Fashion as Cultural Bridge</h3>\n\n<p>Cultural fusion streetwear represents more than a fashion trend - it\'s a movement toward understanding, appreciation, and celebration of our diverse heritage. Brands like Edition By Punjab are showing how traditional elements can be respectfully integrated into contemporary fashion, creating pieces that honor the past while speaking to the present.</p>\n\n<p>As you explore cultural fusion fashion, remember that the most powerful pieces are those that come from genuine connection and understanding. Whether you\'re expressing your own heritage or appreciating others\', let your fashion choices build bridges and start conversations.</p>\n\n<p>In a world that can sometimes feel divided, cultural fusion fashion reminds us of our shared humanity and the beauty that emerges when different traditions come together with respect, creativity, and love.</p>', NULL, 'Cultural Fusion Fashion | Punjabi Heritage Meets Modern Streetwear', 'Discover how Punjabi heritage influences modern streetwear fashion. Cultural fusion clothing combining traditional elements with contemporary design.', 'cultural fusion fashion, punjabi streetwear, heritage fashion, cultural clothing australia, fusion streetwear', 'Edition By Punjab', 10, '[\"Cultural Fusion\",\"Punjabi Fashion\",\"Heritage Style\",\"Modern Streetwear\",\"Cultural Identity\"]', 1, 1, '2025-09-02 16:13:56', 976, '2025-09-05 16:13:56', '2025-09-05 16:30:48'),
(3, 'Sustainable Streetwear Australia: Eco-Friendly Fashion That Doesn\'t Compromise Style', 'sustainable-streetwear-australia-eco-friendly-fashion', 'Learn about sustainable streetwear options in Australia, eco-friendly materials, and how to build a conscious wardrobe without sacrificing style.', '<h2>The Sustainable Streetwear Revolution in Australia</h2>\n\n<p>As consciousness around environmental impact grows, Australian streetwear enthusiasts are leading a shift toward sustainable fashion that doesn\'t compromise on style. The movement proves that looking good and doing good aren\'t mutually exclusive - in fact, they can enhance each other.</p>\n\n<h3>Why Sustainable Streetwear Matters</h3>\n\n<p>The fashion industry is one of the world\'s largest polluters, but streetwear brands have the power to drive significant change through:</p>\n\n<ul>\n    <li><strong>Material Innovation:</strong> Developing eco-friendly fabrics and processes</li>\n    <li><strong>Production Transparency:</strong> Showing consumers exactly how clothes are made</li>\n    <li><strong>Circular Design:</strong> Creating clothes that can be recycled or upcycled</li>\n    <li><strong>Local Manufacturing:</strong> Reducing carbon footprint through shorter supply chains</li>\n</ul>\n\n<div style=\"background: #d4edda; border: 1px solid #c3e6cb; padding: 1.5rem; margin: 2rem 0; border-radius: 0.375rem;\">\n    <h4 style=\"color: #155724;\">🌱 The Environmental Impact of Fast Fashion</h4>\n    <ul>\n        <li><strong>Water Usage:</strong> 2,700 liters needed for one cotton t-shirt</li>\n        <li><strong>Waste Generation:</strong> 92 million tons of textile waste annually</li>\n        <li><strong>Chemical Pollution:</strong> 20% of industrial water pollution from textiles</li>\n        <li><strong>Carbon Footprint:</strong> 10% of global carbon emissions from fashion</li>\n    </ul>\n</div>\n\n<h3>Sustainable Materials in Modern Streetwear</h3>\n\n<h4>Eco-Friendly Fabric Options</h4>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #28a745; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Material</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Benefits</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Best For</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Care Tips</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Organic Cotton</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">No pesticides, less water usage</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">T-shirts, hoodies</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Cold wash, air dry</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Recycled Polyester</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Made from plastic bottles</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Activewear, outerwear</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Low heat settings</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Hemp</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Naturally antimicrobial, durable</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Casual wear, accessories</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Machine washable, softens with use</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Tencel/Lyocell</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Made from sustainably sourced wood</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Base layers, blends</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Gentle cycle, reshape when damp</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3>Australian Sustainable Streetwear Brands</h3>\n\n<p>The Australian fashion scene is home to innovative brands leading the sustainable streetwear movement:</p>\n\n<h4>Local Sustainability Leaders</h4>\n\n<ul>\n    <li><strong>Edition By Punjab:</strong> Combining cultural heritage with sustainable practices</li>\n    <li><strong>Afends:</strong> Hemp-based streetwear with surf culture influences</li>\n    <li><strong>Neuw Denim:</strong> Sustainable denim with streetwear aesthetics</li>\n    <li><strong>Kowtow:</strong> Ethical basics with contemporary design</li>\n</ul>\n\n<div style=\"background: #fff3cd; border: 1px solid #ffeaa7; padding: 1.5rem; margin: 2rem 0; border-radius: 0.375rem;\">\n    <h4 style=\"color: #856404;\">💡 What Makes Edition By Punjab Sustainable?</h4>\n    <ul>\n        <li><strong>Quality Focus:</strong> Creating pieces designed to last years, not seasons</li>\n        <li><strong>Ethical Production:</strong> Fair labor practices and safe working conditions</li>\n        <li><strong>Material Consciousness:</strong> Carefully selected sustainable fabrics</li>\n        <li><strong>Cultural Preservation:</strong> Supporting traditional craftsmanship</li>\n    </ul>\n</div>\n\n<h3>Building a Sustainable Streetwear Wardrobe</h3>\n\n<h4>The 30-Wear Test</h4>\n\n<p>Before buying any piece, ask yourself: \"Will I wear this at least 30 times?\" This simple test helps you:</p>\n\n<ul>\n    <li>Avoid impulse purchases</li>\n    <li>Focus on versatile pieces</li>\n    <li>Invest in quality over quantity</li>\n    <li>Reduce overall consumption</li>\n</ul>\n\n<h4>Essential Sustainable Streetwear Pieces</h4>\n\n<ol>\n    <li><strong>High-Quality Hoodie:</strong> The foundation of any streetwear wardrobe</li>\n    <li><strong>Organic Cotton Tees:</strong> In neutral colors that mix and match easily</li>\n    <li><strong>Durable Denim:</strong> Well-made jeans that improve with age</li>\n    <li><strong>Versatile Outerwear:</strong> A jacket that works across seasons</li>\n    <li><strong>Quality Footwear:</strong> Shoes that can be resoled or repaired</li>\n</ol>\n\n<h3>Sustainable Styling Tips</h3>\n\n<h4>Maximize Your Wardrobe</h4>\n\n<p>Get more from fewer pieces with these sustainable styling strategies:</p>\n\n<div style=\"background: #e9ecef; padding: 1.5rem; margin: 2rem 0; border-left: 4px solid #6c757d;\">\n    <h5>Creative Styling Techniques:</h5>\n    <ul>\n        <li><strong>Layering:</strong> Create different looks with the same base pieces</li>\n        <li><strong>Accessorizing:</strong> Transform outfits with sustainable accessories</li>\n        <li><strong>Mixing Seasons:</strong> Wear pieces year-round with smart layering</li>\n        <li><strong>DIY Customization:</strong> Personalize pieces to refresh their look</li>\n    </ul>\n</div>\n\n<h3>Care and Maintenance for Longevity</h3>\n\n<p>Proper care is crucial for sustainable fashion - it extends the life of your clothes and reduces environmental impact:</p>\n\n<h4>Sustainable Care Practices</h4>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #6f42c1; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Practice</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Environmental Benefit</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Fashion Benefit</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Cold Water Washing</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">90% less energy usage</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Prevents shrinking and fading</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Air Drying</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Zero energy consumption</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Prevents fabric damage</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Spot Cleaning</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Reduces washing frequency</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Maintains fabric integrity</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Professional Repairs</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Extends garment lifespan</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Maintains original fit and style</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3>The Economics of Sustainable Fashion</h3>\n\n<h4>Cost Per Wear Analysis</h4>\n\n<p>While sustainable streetwear often has a higher upfront cost, the investment pays off over time:</p>\n\n<div style=\"background: #f8f9fa; padding: 2rem; margin: 2rem 0; border-left: 4px solid #007bff;\">\n    <h5>Example: Premium Hoodie Investment</h5>\n    <ul>\n        <li><strong>Fast Fashion Hoodie:</strong> $30, lasts 10 wears = $3 per wear</li>\n        <li><strong>Sustainable Hoodie:</strong> $120, lasts 200+ wears = $0.60 per wear</li>\n        <li><strong>Long-term Savings:</strong> Plus better style, comfort, and environmental impact</li>\n    </ul>\n</div>\n\n<h3>Upcycling and DIY Culture</h3>\n\n<p>The sustainable streetwear movement embraces creativity through upcycling and customization:</p>\n\n<h4>Popular DIY Techniques</h4>\n\n<ul>\n    <li><strong>Distressing:</strong> Adding character to plain pieces</li>\n    <li><strong>Embroidery:</strong> Personalizing items with cultural or personal symbols</li>\n    <li><strong>Patchwork:</strong> Combining different fabrics for unique looks</li>\n    <li><strong>Natural Dyeing:</strong> Using plant-based dyes for custom colors</li>\n</ul>\n\n<h3>Second-Hand and Vintage Shopping</h3>\n\n<p>Thrift shopping is a cornerstone of sustainable streetwear, offering unique pieces with character:</p>\n\n<h4>Australia\'s Best Thrift Shopping Destinations</h4>\n\n<ul>\n    <li><strong>Melbourne:</strong> Chapel Street, Fitzroy vintage stores</li>\n    <li><strong>Sydney:</strong> Newtown, Surry Hills thrift shops</li>\n    <li><strong>Brisbane:</strong> West End, Fortitude Valley vintage markets</li>\n    <li><strong>Perth:</strong> Fremantle markets, Leederville op shops</li>\n</ul>\n\n<blockquote style=\"background: #e9ecef; padding: 1.5rem; margin: 2rem 0; font-style: italic; border-left: 4px solid #6c757d;\">\n\"The best streetwear pieces often have stories - whether they\'re vintage finds with decades of history or new pieces made by brands that care about their impact. Every garment should have meaning beyond just looking good.\" - Sustainable Fashion Advocate, Sydney\n</blockquote>\n\n<h3>The Future of Sustainable Streetwear</h3>\n\n<p>Innovation continues to drive the sustainable fashion movement forward:</p>\n\n<h4>Emerging Technologies</h4>\n\n<ul>\n    <li><strong>Bio-fabricated Materials:</strong> Lab-grown leather and textiles</li>\n    <li><strong>Circular Design:</strong> Clothes designed for disassembly and recycling</li>\n    <li><strong>Blockchain Transparency:</strong> Tracking garments from fiber to finished product</li>\n    <li><strong>Rental Platforms:</strong> Access to designer pieces without ownership</li>\n</ul>\n\n<h3>Making the Switch to Sustainable Streetwear</h3>\n\n<h4>Start Where You Are</h4>\n\n<p>Transitioning to sustainable streetwear doesn\'t require a complete wardrobe overhaul:</p>\n\n<ol>\n    <li><strong>Audit Your Current Wardrobe:</strong> Identify what you actually wear</li>\n    <li><strong>Repair and Refresh:</strong> Fix and style existing pieces differently</li>\n    <li><strong>Buy Mindfully:</strong> Research brands before purchasing</li>\n    <li><strong>Quality Over Quantity:</strong> Invest in pieces that will last</li>\n    <li><strong>Support Local Brands:</strong> Reduce environmental impact of shipping</li>\n</ol>\n\n<h3>Conclusion: Style with Purpose</h3>\n\n<p>Sustainable streetwear represents the evolution of fashion consciousness - proving that we can express our individual style while being mindful of our collective impact. Australian brands like Edition By Punjab are leading by example, showing that sustainability and style are natural partners.</p>\n\n<p>The movement toward sustainable streetwear isn\'t just about the clothes we wear - it\'s about the values we embody and the future we want to create. Every conscious choice, from the brands we support to how we care for our clothes, contributes to a more sustainable and stylish world.</p>\n\n<p>As you build your streetwear collection, remember that the most sustainable piece is one you\'ll love and wear for years to come. Choose wisely, wear proudly, and inspire others to join the sustainable fashion revolution.</p>', NULL, 'Sustainable Streetwear Australia | Eco-Friendly Fashion Guide 2024', 'Discover sustainable streetwear options in Australia. Eco-friendly materials, ethical fashion choices, and conscious style without compromise.', 'sustainable streetwear, eco friendly fashion australia, ethical streetwear, sustainable fashion, green clothing', 'Edition By Punjab', 7, '[\"Sustainable Fashion\",\"Eco-Friendly\",\"Ethical Streetwear\",\"Green Fashion\",\"Conscious Style\"]', 1, 1, '2025-08-31 16:13:56', 518, '2025-09-05 16:13:56', '2025-09-05 16:13:56'),
(4, 'How to Style Hoodies: From Casual to Elevated Streetwear Looks', 'how-to-style-hoodies-casual-elevated-streetwear-looks', 'Master the art of hoodie styling with our comprehensive guide. From casual comfort to elevated streetwear, discover versatile ways to wear your favorite hoodies.', '<h2>The Art of Hoodie Styling: From Basic to Exceptional</h2>\n\n<p>The hoodie is the cornerstone of streetwear fashion - versatile, comfortable, and endlessly styleable. Whether you\'re heading to class, meeting friends, or making a style statement, mastering hoodie styling can elevate your entire wardrobe game.</p>\n\n<h3>Understanding Hoodie Fits and Silhouettes</h3>\n\n<p>The foundation of great hoodie styling starts with understanding different fits and how they work with various body types and style preferences.</p>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #dc3545; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Fit Type</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Characteristics</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Best For</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Styling Tips</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Oversized</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Loose, boxy, dropped shoulders</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Relaxed looks, layering</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Balance with fitted bottoms</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Regular Fit</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Classic proportions, comfortable</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Versatile everyday wear</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Works with any bottoms</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Cropped</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Shorter length, modern cut</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">High-waisted bottoms</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Great for showing waist definition</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Fitted</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Tailored, body-conscious</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Athletic builds, layering base</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Perfect under jackets</td>\n        </tr>\n    </tbody>\n</table>\n\n<p>Remember, the key to great hoodie styling is proportion and balance - use your hoodie as an anchor piece and build the rest of your outfit around it.</p>', NULL, 'How to Style Hoodies | Streetwear Fashion Guide | Edition By Punjab', 'Learn how to style hoodies for different occasions. From casual to elevated looks, master streetwear fashion with our comprehensive hoodie styling guide.', 'how to style hoodies, hoodie fashion, streetwear styling, casual fashion, hoodie outfits', 'Edition By Punjab', 6, '[\"Hoodie Styling\",\"Fashion Tips\",\"Streetwear Guide\",\"Casual Fashion\",\"Style Advice\"]', 1, 0, '2025-08-29 16:13:56', 530, '2025-09-05 16:13:56', '2025-09-05 16:13:56'),
(5, 'Australian Street Style Icons: Influencers Shaping Fashion Culture', 'australian-street-style-icons-influencers-fashion-culture', 'Meet the Australian street style icons and influencers who are defining fashion culture, from Melbourne\'s creative scene to Sydney\'s urban fashion.', '<h2>Australian Street Style Icons Shaping Fashion Culture</h2>\n\n<p>Australia\'s street style scene is thriving with creative individuals who are redefining fashion culture across the country. From Melbourne\'s artistic lanes to Sydney\'s coastal streets, these style icons are inspiring a generation of fashion enthusiasts.</p>\n\n<h3>The Melbourne Creative Scene</h3>\n\n<p>Melbourne\'s reputation as Australia\'s cultural capital is reflected in its diverse and experimental street style community.</p>\n\n<div style=\"background: #f8f9fa; padding: 2rem; margin: 2rem 0; border-left: 4px solid #007bff;\">\n    <h4>Melbourne Style Characteristics</h4>\n    <ul>\n        <li><strong>Artistic Expression:</strong> Fashion as wearable art</li>\n        <li><strong>Vintage Integration:</strong> Mixing decades seamlessly</li>\n        <li><strong>Weather Adaptability:</strong> Mastering the art of layering</li>\n        <li><strong>Cultural Diversity:</strong> Celebrating multicultural influences</li>\n    </ul>\n</div>\n\n<p>The street style scene continues to evolve with new voices and perspectives shaping Australian fashion culture.</p>', NULL, 'Australian Street Style Icons | Fashion Influencers & Culture Leaders', 'Discover Australian street style icons and fashion influencers shaping culture. From Melbourne to Sydney, meet the leaders of urban fashion.', 'australian street style, fashion influencers australia, street style icons, urban fashion australia, fashion culture', 'Edition By Punjab', 9, '[\"Street Style\",\"Fashion Influencers\",\"Australian Fashion\",\"Urban Culture\",\"Style Icons\"]', 1, 0, '2025-08-26 16:13:56', 583, '2025-09-05 16:13:56', '2025-09-05 16:13:56'),
(6, 'Building a Capsule Streetwear Wardrobe: Essential Pieces for Every Style', 'building-capsule-streetwear-wardrobe-essential-pieces', 'Create the perfect capsule streetwear wardrobe with our guide to essential pieces. Quality over quantity for a stylish, versatile, and sustainable approach.', '<h2>Building the Perfect Capsule Streetwear Wardrobe</h2>\n\n<p>A capsule wardrobe approach to streetwear focuses on quality, versatility, and personal style expression. By carefully selecting essential pieces that work together seamlessly, you can create countless outfit combinations while maintaining a cohesive aesthetic.</p>\n\n<h3>The Philosophy Behind Capsule Streetwear</h3>\n\n<p>Capsule streetwear isn\'t about having fewer clothes - it\'s about having the right clothes. This approach emphasizes:</p>\n\n<ul>\n    <li><strong>Quality over Quantity:</strong> Investment pieces that last</li>\n    <li><strong>Versatility:</strong> Items that work in multiple contexts</li>\n    <li><strong>Personal Expression:</strong> Pieces that reflect your unique style</li>\n    <li><strong>Sustainability:</strong> Conscious consumption and longevity</li>\n</ul>\n\n<p>A well-curated capsule wardrobe becomes the foundation for effortless style and creative expression.</p>', NULL, 'Capsule Streetwear Wardrobe | Essential Pieces & Style Guide', 'Build the perfect capsule streetwear wardrobe with essential pieces. Quality over quantity approach to versatile, stylish, and sustainable fashion.', 'capsule wardrobe, streetwear essentials, minimalist fashion, wardrobe basics, quality streetwear', 'Edition By Punjab', 8, '[\"Capsule Wardrobe\",\"Essential Pieces\",\"Minimalist Fashion\",\"Wardrobe Building\",\"Quality Fashion\"]', 1, 0, '2025-08-24 16:13:56', 738, '2025-09-05 16:13:56', '2025-09-05 16:13:56'),
(7, 'Streetwear Color Theory: Mastering the Art of Urban Fashion Palettes', 'streetwear-color-theory-urban-fashion-palettes', 'Understand color theory in streetwear fashion. Learn how to create stunning outfits using color combinations that reflect your personality and style.', '<h2>Mastering Color Theory in Streetwear Fashion</h2>\n\n<p>Color is one of the most powerful tools in streetwear styling, capable of conveying mood, personality, and cultural identity. Understanding color theory principles can transform your approach to building outfits and expressing your personal style.</p>\n\n<h3>The Psychology of Color in Streetwear</h3>\n\n<p>Different colors evoke different emotions and create various impressions:</p>\n\n<table style=\"width: 100%; border-collapse: collapse; margin: 2rem 0;\">\n    <thead>\n        <tr style=\"background: #6f42c1; color: white;\">\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Color Family</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Psychological Impact</th>\n            <th style=\"padding: 1rem; border: 1px solid #ddd;\">Streetwear Application</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Earth Tones</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Grounding, authentic, stable</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Base colors for versatile styling</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Bold Brights</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Energetic, confident, attention-grabbing</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Statement pieces and accents</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Monochrome</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Clean, modern, sophisticated</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Minimalist streetwear aesthetics</td>\n        </tr>\n    </tbody>\n</table>\n\n<p>Understanding these color relationships helps create intentional, impactful streetwear looks that communicate your personal style.</p>', NULL, 'Streetwear Color Theory | Urban Fashion Color Guide & Palettes', 'Master streetwear color theory and urban fashion palettes. Learn color combinations, styling techniques, and how to create stunning streetwear outfits.', 'streetwear color theory, fashion color guide, urban fashion colors, streetwear styling, color combinations', 'Edition By Punjab', 7, '[\"Color Theory\",\"Fashion Styling\",\"Urban Fashion\",\"Color Palettes\",\"Style Guide\"]', 1, 0, '2025-08-22 16:13:56', 560, '2025-09-05 16:13:56', '2025-09-05 16:15:21');
INSERT INTO `blogs` (`id`, `title`, `slug`, `excerpt`, `content`, `featured_image`, `meta_title`, `meta_description`, `meta_keywords`, `author`, `read_time`, `tags`, `is_published`, `is_featured`, `published_at`, `views`, `created_at`, `updated_at`) VALUES
(8, 'The Evolution of Streetwear: From Subculture to Mainstream Fashion', 'evolution-streetwear-subculture-mainstream-fashion', 'Trace the fascinating journey of streetwear from underground subculture to global fashion phenomenon, exploring its cultural impact and future directions.', '<h2>The Evolution of Streetwear: From Subculture to Global Phenomenon</h2>\n\n<p>Streetwear\'s journey from underground movement to mainstream fashion represents one of the most significant cultural shifts in modern fashion history. Understanding this evolution provides context for today\'s diverse and dynamic streetwear landscape.</p>\n\n<h3>Origins in Subculture</h3>\n\n<p>Streetwear emerged from various subcultures in the 1970s and 1980s, including:</p>\n\n<ul>\n    <li><strong>Surf Culture:</strong> Casual, functional clothing for beach lifestyle</li>\n    <li><strong>Skateboarding:</strong> Durable, comfortable clothes for street skating</li>\n    <li><strong>Hip-Hop:</strong> Fashion as cultural expression and identity</li>\n    <li><strong>Punk Rock:</strong> DIY aesthetics and anti-establishment messaging</li>\n</ul>\n\n<div style=\"background: #e9ecef; padding: 1.5rem; margin: 2rem 0; border-left: 4px solid #6c757d;\">\n    <h4>Key Characteristics of Early Streetwear</h4>\n    <ul>\n        <li>Functional design meeting lifestyle needs</li>\n        <li>Cultural identity and community belonging</li>\n        <li>Authentic connection to subcultures</li>\n        <li>Limited production and exclusivity</li>\n    </ul>\n</div>\n\n<p>Today\'s streetwear continues to honor these roots while evolving to meet contemporary cultural and aesthetic needs.</p>', NULL, 'Evolution of Streetwear | From Subculture to Mainstream Fashion History', 'Explore the evolution of streetwear from underground subculture to mainstream fashion. Cultural impact, history, and future of urban style.', 'streetwear history, fashion evolution, urban culture, streetwear subculture, fashion history', 'Edition By Punjab', 11, '[\"Fashion History\",\"Streetwear Evolution\",\"Urban Culture\",\"Fashion Culture\",\"Style History\"]', 1, 0, '2025-08-20 16:13:56', 604, '2025-09-05 16:13:56', '2025-09-08 19:18:33');

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache_locks`
--

CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `carts`
--

CREATE TABLE `carts` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attributes`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `carts`
--

INSERT INTO `carts` (`id`, `session_id`, `user_id`, `product_id`, `quantity`, `price`, `attributes`, `created_at`, `updated_at`) VALUES
(1, 'cart_68a77a2130b6d4.37321736', NULL, 1, 1, 100.00, NULL, '2025-08-22 02:57:21', '2025-08-22 02:57:21'),
(2, NULL, 1, 2, 2, 100.00, NULL, '2025-08-22 04:00:19', '2025-09-06 02:59:32'),
(3, 'cart_68a94f23e7f015.12285575', NULL, 1, 1, 100.00, '{\"size\":\"XL\",\"color\":\"Blue\"}', '2025-08-23 12:18:27', '2025-08-23 12:18:27'),
(5, 'cart_68b2a7452af155.34581985', NULL, 2, 1, 100.00, '{\"size\":\"S\",\"color\":\"Blue\"}', '2025-08-30 14:24:53', '2025-08-30 14:24:53'),
(8, NULL, 3, 2, 1, 100.00, '{\"size\":\"S\",\"color\":\"Black\"}', '2025-09-06 13:16:01', '2025-09-06 13:22:17');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `parent_id` bigint(20) UNSIGNED DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keywords` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `parent_id`, `name`, `slug`, `description`, `image`, `meta_title`, `meta_description`, `meta_keywords`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES
(1, NULL, 'New Arrivals', 'new-arrivals', NULL, NULL, NULL, NULL, NULL, 1, 0, '2025-08-22 01:06:12', '2025-08-22 01:06:12');

-- --------------------------------------------------------

--
-- Table structure for table `community_pages`
--

CREATE TABLE `community_pages` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `page_key` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text DEFAULT NULL,
  `images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`images`)),
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `community_pages`
--

INSERT INTO `community_pages` (`id`, `page_key`, `title`, `content`, `images`, `meta_title`, `meta_description`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'community-index', 'Community Main Page', '<h2>Welcome to Our Community</h2><p>Join our vibrant community of fashion enthusiasts and share your style with the world. Discover authentic Punjabi-inspired streetwear and connect with like-minded individuals who celebrate culture through fashion.</p>', '[]', 'Community - Edition By Punjab | Share Your Style', 'Join the Edition By Punjab community. Share your style, discover cultural fashion, and connect with fellow streetwear enthusiasts.', 1, '2025-09-06 13:11:31', '2025-09-06 13:11:31'),
(2, 'community-gallery', 'Community Gallery', '<h2>Style Gallery</h2><p>Browse our community gallery featuring real customers showcasing their Edition By Punjab pieces. From street style to cultural celebrations, see how our community wears their heritage with pride.</p>', '[]', 'Community Gallery - Style Inspiration | Edition By Punjab', 'Browse our community gallery featuring real customers in Edition By Punjab streetwear. Get inspired by authentic cultural fashion.', 1, '2025-09-06 13:11:31', '2025-09-06 13:11:31'),
(3, 'community-spotlight', 'Customer Spotlight', '<h2>Community Spotlight</h2><p>Meet the inspiring individuals in our community. Each month, we highlight customers who embody the spirit of cultural pride and authentic style. Their stories showcase how fashion can be a powerful expression of identity.</p>', '[]', 'Customer Spotlight - Community Stories | Edition By Punjab', 'Meet inspiring customers who embody cultural pride and authentic style. Read their stories and fashion journeys.', 1, '2025-09-06 13:11:31', '2025-09-06 13:11:31'),
(4, 'community-submit', 'Submit Your Style', '<h2>Share Your Style</h2><p>Ready to be featured in our community? Submit your photos wearing Edition By Punjab pieces and share your story. We love celebrating the diversity and creativity of our community members.</p><div class=\"alert alert-info\"><strong>Submission Guidelines:</strong><ul><li>Photos must feature Edition By Punjab products</li><li>High-quality images preferred</li><li>Include a brief story about your style</li><li>By submitting, you agree to potential feature use</li></ul></div>', '[]', 'Submit Your Style - Be Featured | Edition By Punjab Community', 'Share your Edition By Punjab style with our community. Submit photos and stories to be featured in our gallery.', 1, '2025-09-06 13:11:31', '2025-09-06 13:11:31');

-- --------------------------------------------------------

--
-- Table structure for table `community_posts`
--

CREATE TABLE `community_posts` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `caption` text NOT NULL,
  `products_featured` varchar(255) DEFAULT NULL,
  `instagram_handle` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) NOT NULL,
  `consent_gallery` tinyint(1) NOT NULL DEFAULT 1,
  `consent_social` tinyint(1) NOT NULL DEFAULT 0,
  `consent_marketing` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `featured` tinyint(1) NOT NULL DEFAULT 0,
  `likes` int(11) NOT NULL DEFAULT 0,
  `approved_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `company_info`
--

CREATE TABLE `company_info` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `about_us` text DEFAULT NULL,
  `mission` text DEFAULT NULL,
  `vision` text DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `social_links` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`social_links`)),
  `whatsapp` varchar(255) DEFAULT NULL,
  `export_countries` text DEFAULT NULL,
  `years_experience` int(11) NOT NULL DEFAULT 0,
  `happy_clients` int(11) NOT NULL DEFAULT 0,
  `products_count` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_code` varchar(255) NOT NULL DEFAULT 'AUD',
  `currency_symbol` varchar(255) NOT NULL DEFAULT '$',
  `tax_rate` decimal(5,2) NOT NULL DEFAULT 10.00,
  `shipping_rate` decimal(10,2) NOT NULL DEFAULT 10.00,
  `free_shipping_threshold` decimal(10,2) NOT NULL DEFAULT 100.00,
  `payment_methods` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payment_methods`)),
  `shop_policies` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`shop_policies`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `company_info`
--

INSERT INTO `company_info` (`id`, `company_name`, `about_us`, `mission`, `vision`, `phone`, `email`, `address`, `logo`, `social_links`, `whatsapp`, `export_countries`, `years_experience`, `happy_clients`, `products_count`, `created_at`, `updated_at`, `currency_code`, `currency_symbol`, `tax_rate`, `shipping_rate`, `free_shipping_threshold`, `payment_methods`, `shop_policies`) VALUES
(1, 'Edition By Punjab', 'Edition By Punjab is a premium fashion brand...', 'To provide high-quality fashion products...', 'To become a leading fashion brand...', '+61 409 843 835', 'info@editionbypunjab.com', 'Sydney, Australia', 'company/QbprZo2168PSnrSOuY4yJillkZeE8CqQTb5afiGw.jpg', '{\"facebook\":\"https:\\/\\/www.facebook.com\\/share\\/16M2ptiXJg\\/?mibextid=wwXIfr\",\"twitter\":null,\"linkedin\":null,\"instagram\":\"https:\\/\\/www.instagram.com\\/editionbypunjab?igsh=MzV1MTdhb3d0a2Uz&utm_source=qr\"}', '+61 409 843 835', NULL, 2, 5000, 1000, '2025-08-20 19:06:06', '2025-08-26 01:39:45', 'AUD', '$', 10.00, 10.00, 100.00, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `code` varchar(50) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `discount_type` enum('fixed','percentage') NOT NULL DEFAULT 'fixed',
  `discount_amount` decimal(10,2) NOT NULL,
  `minimum_amount` decimal(10,2) DEFAULT NULL,
  `usage_limit` int(11) DEFAULT NULL,
  `used_count` int(11) NOT NULL DEFAULT 0,
  `valid_from` datetime NOT NULL,
  `valid_until` datetime NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `discount_campaigns`
--

CREATE TABLE `discount_campaigns` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `discount_percentage` decimal(5,2) NOT NULL,
  `starts_at` datetime NOT NULL,
  `ends_at` datetime NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `product_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`product_ids`)),
  `category_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`category_ids`)),
  `banner_image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inquiries`
--

CREATE TABLE `inquiries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `product_id` bigint(20) UNSIGNED DEFAULT NULL,
  `status` enum('new','in_progress','completed') NOT NULL DEFAULT 'new',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `instagram_feeds`
--

CREATE TABLE `instagram_feeds` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `image` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL,
  `caption` text DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `instagram_feeds`
--

INSERT INTO `instagram_feeds` (`id`, `image`, `link`, `caption`, `sort_order`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'instagram/OrT89Z044nGlCjjFz2DT9XQ4StzajVHkM9fy3fPc.jpg', 'https://www.instagram.com/editionbypunjab', NULL, 0, 1, '2025-08-26 01:33:35', '2025-08-26 01:33:35'),
(2, 'instagram/r0D7LX51n7WwaKkI4wYEySBYbjZ772Ti5dwOYLL7.jpg', 'https://www.instagram.com/editionbypunjab', NULL, 1, 1, '2025-08-26 01:35:24', '2025-08-26 01:35:24');

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) UNSIGNED NOT NULL,
  `reserved_at` int(10) UNSIGNED DEFAULT NULL,
  `available_at` int(10) UNSIGNED NOT NULL,
  `created_at` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `legal_pages`
--

CREATE TABLE `legal_pages` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `meta_description` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `legal_pages`
--

INSERT INTO `legal_pages` (`id`, `title`, `slug`, `content`, `meta_description`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Terms of Service', 'terms-of-service', '\n<h2>Acceptance of Terms</h2>\n<p>By accessing and using the Edition By Punjab website, you accept and agree to be bound by the terms and provision of this agreement. These Terms of Service apply to all users of the site, including without limitation users who are browsers, vendors, customers, merchants, and/or contributors of content.</p>\n\n<div class=\"terms-highlights\">\n    <div class=\"term-highlight\">\n        <h4>Age Requirement</h4>\n        <p>You must be at least 18 years old to use our services</p>\n    </div>\n    <div class=\"term-highlight\">\n        <h4>Jurisdiction</h4>\n        <p>These terms are governed by the laws of the United States</p>\n    </div>\n    <div class=\"term-highlight\">\n        <h4>Updates</h4>\n        <p>We reserve the right to update these terms at any time</p>\n    </div>\n</div>\n\n<h2>Use License</h2>\n<p>Permission is granted to temporarily download one copy of the materials (information or software) on Edition By Punjab\'s website for personal, non-commercial transitory viewing only. This is the grant of a license, not a transfer of title.</p>\n\n<h3>Under this license you may NOT:</h3>\n<ul>\n    <li>Modify or copy the materials</li>\n    <li>Use the materials for any commercial purpose or public display</li>\n    <li>Attempt to decompile or reverse engineer any software</li>\n    <li>Remove any copyright or proprietary notations</li>\n    <li>Transfer the materials to another person</li>\n</ul>\n\n<h2>Product Information</h2>\n<p>We strive to display colors as accurately as possible, but screen variations may occur. Please refer to our size guide for accurate measurements. Images are for illustration purposes and may vary slightly. We ensure accuracy but reserve the right to correct any errors.</p>\n\n<h2>Order Acceptance</h2>\n<p>Placing an order constitutes an offer to purchase products. Receipt of order confirmation does not signify acceptance. We reserve the right to accept or decline your order and may require additional verification for certain orders.</p>\n\n<h2>Pricing</h2>\n<p>All prices are subject to change without notice. Promotional prices are limited time offers. We reserve the right to correct pricing errors. Prices exclude applicable taxes unless stated.</p>\n\n<h2>Payment</h2>\n<p>We accept Visa, Mastercard, American Express, Discover, PayPal, and Apple Pay. All payments are processed securely through encrypted channels. We never store your complete payment information on our servers.</p>\n\n<p>Payment must be received by us prior to our dispatch of your order. For credit card payments, your card will be charged at the time of purchase.</p>\n\n<h2>Shipping</h2>\n<p>Shipping times and costs vary based on location and shipping method selected. Please refer to our Shipping Policy for detailed information.</p>\n\n<ul>\n    <li><strong>Processing Time:</strong> 1-2 business days</li>\n    <li><strong>Delivery Time:</strong> 5-7 business days (standard)</li>\n    <li><strong>Free Shipping:</strong> Orders over $100</li>\n</ul>\n\n<h2>Returns and Refunds</h2>\n<p>Please review our Return & Refund Policy for detailed information about returning products and obtaining refunds.</p>\n\n<ul>\n    <li><strong>30-Day Returns:</strong> Return within 30 days of delivery</li>\n    <li><strong>Original Condition:</strong> Items must be unworn with tags</li>\n    <li><strong>Full Refund:</strong> 100% money back guarantee</li>\n</ul>\n\n<h2>Privacy</h2>\n<p>Your use of our website is also governed by our Privacy Policy. Please review our Privacy Policy, which also governs your visit to our website, to understand our practices.</p>\n\n<h3>Our Privacy Commitment:</h3>\n<ul>\n    <li>We never sell your personal information</li>\n    <li>We use industry-standard encryption</li>\n    <li>We respect your communication preferences</li>\n    <li>You can request data deletion at any time</li>\n</ul>\n\n<h2>Limitation of Liability</h2>\n<p>In no event shall Edition By Punjab or its directors, employees, partners, agents, suppliers, or affiliates, be liable for any indirect, incidental, special, consequential, or punitive damages, including without limitation, loss of profits, data, use, goodwill, or other intangible losses.</p>\n\n<p>Our liability is limited to the maximum extent permitted by law. We shall not be liable for:</p>\n<ul>\n    <li>Any errors or omissions in content</li>\n    <li>Personal injury or property damage</li>\n    <li>Unauthorized access to our servers</li>\n    <li>Interruption of transmission to or from our website</li>\n    <li>Any bugs, viruses, or trojan horses</li>\n</ul>\n\n<h2>Contact Information</h2>\n<p>If you have any questions about these Terms of Service, please contact us:</p>\n\n<ul>\n    <li><strong>Email:</strong> legal@editionbypunjab.com</li>\n    <li><strong>Phone:</strong> +1 (555) 123-4567</li>\n    <li><strong>Address:</strong> 123 Fashion Street, City, State 12345</li>\n    <li><strong>Business Hours:</strong> Mon-Fri: 9AM-6PM EST</li>\n</ul>\n        ', 'Terms and conditions for using Edition By Punjab website and services', 1, '2025-09-05 13:00:59', '2025-09-05 13:00:59'),
(2, 'Privacy Policy', 'privacy-policy', '<h2>Information We Collect</h2>\r\n\r\n<p>We collect information you provide directly to us, such as when you create an account, make a purchase, or contact us. This information may include:</p>\r\n\r\n<ul>\r\n	<li>Personal identification information (name, email address, phone number)</li>\r\n	<li>Billing and shipping addresses</li>\r\n	<li>Payment information (processed securely through our payment processors)</li>\r\n	<li>Purchase history and preferences</li>\r\n	<li>Communication preferences</li>\r\n	<li>Any other information you choose to provide</li>\r\n</ul>\r\n\r\n<h2>How We Use Your Information</h2>\r\n\r\n<p>We use the information we collect to provide, maintain, and improve our services, including to:</p>\r\n\r\n<p>Process Orders</p>\r\n\r\n<p>Process and fulfill your orders, including payment processing and delivery</p>\r\n\r\n<p>Communication</p>\r\n\r\n<p>Communicate with you about your orders, account, and customer service inquiries</p>\r\n\r\n<p>Marketing</p>\r\n\r\n<p>Send you marketing communications with your consent</p>\r\n\r\n<p>Improvement</p>\r\n\r\n<p>Improve our products, services, and user experience</p>\r\n\r\n<p>Protection</p>\r\n\r\n<p>Protect against fraudulent or illegal activities</p>\r\n\r\n<p>Compliance</p>\r\n\r\n<p>Comply with legal obligations and enforce our terms</p>\r\n\r\n<h2>Information Sharing</h2>\r\n\r\n<p>We do not sell, trade, or otherwise transfer your personal information to third parties without your consent, except as described in this policy. We may share your information with:</p>\r\n\r\n<ul>\r\n	<li>Service providers who assist us in operating our website and conducting our business</li>\r\n	<li>Payment processors for secure transaction processing</li>\r\n	<li>Shipping partners to deliver your orders</li>\r\n	<li>Law enforcement or regulatory authorities when required by law</li>\r\n	<li>Other parties with your explicit consent</li>\r\n</ul>\r\n\r\n<h2>Data Security</h2>\r\n\r\n<p>We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p>\r\n\r\n<p>Our security measures include:</p>\r\n\r\n<ul>\r\n	<li>SSL encryption for data transmission</li>\r\n	<li>Secure servers and databases</li>\r\n	<li>Regular security audits and updates</li>\r\n	<li>Limited access to personal information</li>\r\n	<li>Employee training on data protection</li>\r\n</ul>\r\n\r\n<h2>Cookies</h2>\r\n\r\n<p>We use cookies and similar tracking technologies to track activity on our website and hold certain information. Cookies are files with small amounts of data which may include an anonymous unique identifier.</p>\r\n\r\n<p>Essential Cookies</p>\r\n\r\n<p>Required for the website to function properly</p>\r\n\r\n<p>Analytics Cookies</p>\r\n\r\n<p>Help us understand how visitors interact with our website</p>\r\n\r\n<p>Marketing Cookies</p>\r\n\r\n<p>Used to deliver relevant advertisements to you</p>\r\n\r\n<h2>Your Rights</h2>\r\n\r\n<p>You have the following rights regarding your personal information:</p>\r\n\r\n<p>Access</p>\r\n\r\n<p>Request access to your personal information</p>\r\n\r\n<p>Correction</p>\r\n\r\n<p>Correct inaccurate or incomplete information</p>\r\n\r\n<p>Deletion</p>\r\n\r\n<p>Request deletion of your information</p>\r\n\r\n<p>Opt-out</p>\r\n\r\n<p>Opt-out of marketing communications</p>\r\n\r\n<h2>Children&#39;s Privacy</h2>\r\n\r\n<p>Our website is not intended for children under 13 years of age. We do not knowingly collect personal information from children under 13. If you are a parent or guardian and believe your child has provided us with personal information, please contact us.</p>\r\n\r\n<h2>Changes to This Policy</h2>\r\n\r\n<p>We may update this privacy policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the &quot;Last updated&quot; date at the top of this policy. You are advised to review this Privacy Policy periodically for any changes.</p>\r\n\r\n<h2>Contact Us</h2>\r\n\r\n<p>If you have questions about this Privacy Policy, please contact us:</p>\r\n\r\n<ul>\r\n	<li><strong>Email:</strong>&nbsp;info@editionbypunjab.com</li>\r\n	<li><strong>Phone:</strong> +1 (555) 123-4567</li>\r\n	<li><strong>Address:</strong> 123 Fashion Street, City, State 12345</li>\r\n</ul>', 'Learn how Edition By Punjab protects your privacy and handles your personal information', 1, '2025-09-05 13:00:59', '2025-09-05 13:02:21'),
(3, 'Shipping Policy', 'shipping-policy', '\n<h2>Processing Time</h2>\n<p>All orders are processed within <strong>1-2 business days</strong>. Orders are not shipped or delivered on weekends or holidays. Same-day processing is available for orders placed before 12 PM EST.</p>\n\n<h2>Shipping Rates & Delivery Times</h2>\n\n<h3>Domestic Shipping (United States)</h3>\n<table style=\"width: 100%; border-collapse: collapse; margin: 1rem 0;\">\n    <thead>\n        <tr style=\"background: #f5f5f5;\">\n            <th style=\"padding: 0.75rem; border: 1px solid #ddd;\">Shipping Method</th>\n            <th style=\"padding: 0.75rem; border: 1px solid #ddd;\">Delivery Time</th>\n            <th style=\"padding: 0.75rem; border: 1px solid #ddd;\">Cost</th>\n            <th style=\"padding: 0.75rem; border: 1px solid #ddd;\">Features</th>\n        </tr>\n    </thead>\n    <tbody>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Standard Shipping</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">5-7 business days</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">$10.00</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Tracking, Insurance</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Express Shipping</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">2-3 business days</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">$25.00</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Priority, Tracking, Insurance</td>\n        </tr>\n        <tr>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\"><strong>Priority Shipping</strong></td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">1-2 business days</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">$40.00</td>\n            <td style=\"padding: 0.75rem; border: 1px solid #ddd;\">Next Day, Signature, Full Insurance</td>\n        </tr>\n    </tbody>\n</table>\n\n<div style=\"background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%); color: white; padding: 2rem; margin: 2rem 0;\">\n    <h4 style=\"color: white;\">FREE Standard Shipping</h4>\n    <p style=\"color: white;\">On all orders over $100 within the United States</p>\n</div>\n\n<h2>International Shipping</h2>\n\n<div class=\"international-zones\" style=\"display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin: 2rem 0;\">\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 1.5rem;\">\n        <h4>Zone 1: North America</h4>\n        <ul>\n            <li>Canada, Mexico</li>\n            <li>7-14 business days</li>\n            <li>Starting at $20</li>\n        </ul>\n    </div>\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 1.5rem;\">\n        <h4>Zone 2: Europe</h4>\n        <ul>\n            <li>EU Countries, UK</li>\n            <li>10-18 business days</li>\n            <li>Starting at $30</li>\n        </ul>\n    </div>\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 1.5rem;\">\n        <h4>Zone 3: Asia Pacific</h4>\n        <ul>\n            <li>Asia, Australia, NZ</li>\n            <li>12-20 business days</li>\n            <li>Starting at $35</li>\n        </ul>\n    </div>\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 1.5rem;\">\n        <h4>Zone 4: Rest of World</h4>\n        <ul>\n            <li>All other countries</li>\n            <li>15-25 business days</li>\n            <li>Starting at $40</li>\n        </ul>\n    </div>\n</div>\n\n<div style=\"background: #FFF3CD; border: 1px solid #FFC107; border-left-width: 4px; padding: 1.5rem; margin: 2rem 0;\">\n    <h4>Important: Customs & Duties</h4>\n    <p>International customers are responsible for any customs duties, taxes, or fees imposed by their country. These charges are not included in our shipping costs.</p>\n</div>\n\n<h2>Order Tracking</h2>\n<p>We provide comprehensive order tracking for all shipments:</p>\n\n<ol>\n    <li><strong>Shipping Confirmation:</strong> Receive email with tracking number once order ships</li>\n    <li><strong>Track Your Order:</strong> Use tracking number on our website or carrier\'s site</li>\n    <li><strong>Delivery Updates:</strong> Get real-time notifications about your package</li>\n</ol>\n\n<h2>Shipping Restrictions</h2>\n<p>Please note the following shipping restrictions:</p>\n\n<ul>\n    <li><strong>Restricted Items:</strong> Some products may have shipping restrictions based on regulations</li>\n    <li><strong>Size & Weight Limits:</strong> Oversized items may incur additional shipping charges</li>\n    <li><strong>Location Restrictions:</strong> We cannot ship to P.O. boxes for certain items</li>\n    <li><strong>Hazardous Materials:</strong> Special handling required for certain products</li>\n</ul>\n\n<h2>Damaged or Lost Packages</h2>\n<p>If your package is damaged or lost during shipping:</p>\n\n<ol>\n    <li><strong>Report Issue:</strong> Contact us immediately if your package is damaged or lost</li>\n    <li><strong>Document Damage:</strong> Take photos of damaged package and items</li>\n    <li><strong>File Claim:</strong> We\'ll handle insurance claims with the carrier</li>\n    <li><strong>Resolution:</strong> Receive replacement or full refund</li>\n</ol>\n\n<div style=\"background: linear-gradient(135deg, #E8F5E9 0%, #C8E6C9 100%); border: 1px solid #4CAF50; border-left-width: 4px; padding: 2rem; margin: 2rem 0;\">\n    <h4>Our Guarantee</h4>\n    <p>All packages are fully insured. If your order is lost or damaged in transit, we will replace it or issue a full refund at no cost to you.</p>\n</div>\n\n<h2>Contact Us</h2>\n<p>For shipping inquiries or assistance:</p>\n\n<ul>\n    <li><strong>Customer Support:</strong> Available 24/7 for shipping questions</li>\n    <li><strong>Email:</strong> shipping@editionbypunjab.com</li>\n    <li><strong>Phone:</strong> +1 (555) 123-4567</li>\n</ul>\n        ', 'Fast, reliable shipping worldwide. Learn about our shipping rates, delivery times, and policies.', 1, '2025-09-05 13:00:59', '2025-09-05 13:00:59'),
(4, 'Refund & Return Policy', 'refund-policy', '\n<div style=\"display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 2rem; margin-bottom: 4rem;\">\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;\">\n        <h3>30 Days</h3>\n        <p>Return Period</p>\n    </div>\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;\">\n        <h3>Free</h3>\n        <p>Return Shipping*</p>\n    </div>\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;\">\n        <h3>100%</h3>\n        <p>Money Back</p>\n    </div>\n    <div style=\"background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;\">\n        <h3>5-7 Days</h3>\n        <p>Refund Processing</p>\n    </div>\n</div>\n\n<h2>Return Period</h2>\n<div style=\"background: linear-gradient(135deg, #f8f8f8 0%, #fff 100%); padding: 1.5rem; border-left: 4px solid #000; margin: 2rem 0;\">\n    <p>We accept returns within <strong>30 days</strong> of delivery. To be eligible for a return, your item must be unused, unworn, and in the same condition that you received it. It must also be in the original packaging with all tags attached.</p>\n</div>\n\n<h2>Return Process</h2>\n<ol>\n    <li><strong>Initiate Return:</strong> Contact our customer service team via email or through your account dashboard</li>\n    <li><strong>Get RMA Number:</strong> Receive your Return Merchandise Authorization (RMA) number within 24 hours</li>\n    <li><strong>Pack Items:</strong> Securely pack the item with all original packaging, tags, and accessories</li>\n    <li><strong>Ship Back:</strong> Ship the item using the prepaid label or a trackable shipping method</li>\n    <li><strong>Receive Refund:</strong> Get your refund processed within 5-7 business days of receipt</li>\n</ol>\n\n<h2>Refund Processing</h2>\n<p>Once we receive your returned item, we will:</p>\n\n<ol>\n    <li><strong>Inspect the Item:</strong> Within 2 business days of receipt</li>\n    <li><strong>Send Confirmation:</strong> Email notification of approval or rejection</li>\n    <li><strong>Process Refund:</strong> 5-7 business days to original payment method</li>\n</ol>\n\n<h2>Non-Returnable Items</h2>\n<p>The following items cannot be returned:</p>\n\n<div style=\"display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; margin: 2rem 0;\">\n    <div style=\"text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;\">\n        <h4>Sale Items</h4>\n        <p>Final sale and clearance items</p>\n    </div>\n    <div style=\"text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;\">\n        <h4>Personalized</h4>\n        <p>Custom-made or personalized products</p>\n    </div>\n    <div style=\"text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;\">\n        <h4>Gift Cards</h4>\n        <p>Digital and physical gift cards</p>\n    </div>\n    <div style=\"text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;\">\n        <h4>Intimate Items</h4>\n        <p>Undergarments and swimwear</p>\n    </div>\n</div>\n\n<h2>Exchanges</h2>\n<div style=\"display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin: 2rem 0;\">\n    <div style=\"padding: 1.5rem; background: #f8f8f8; border-left: 3px solid #4CAF50;\">\n        <h4>Size Exchanges</h4>\n        <p>We offer free size exchanges within 30 days for items in stock</p>\n    </div>\n    <div style=\"padding: 1.5rem; background: #f8f8f8; border-left: 3px solid #4CAF50;\">\n        <h4>Color Exchanges</h4>\n        <p>Exchange for a different color if available in the same style</p>\n    </div>\n    <div style=\"padding: 1.5rem; background: #f8f8f8; border-left: 3px solid #4CAF50;\">\n        <h4>Exchange Shipping</h4>\n        <p>Free shipping both ways for exchanges on orders over $100</p>\n    </div>\n</div>\n\n<h2>Damaged or Defective Items</h2>\n<div style=\"background: #FFEBEE; border: 1px solid #EF5350; border-left-width: 4px; padding: 1.5rem; margin: 2rem 0;\">\n    <h4>Report Immediately</h4>\n    <p>If you receive a damaged or defective item, please contact us within 48 hours with photos of the damage.</p>\n</div>\n\n<p>We will:</p>\n<ul>\n    <li>Arrange for immediate replacement</li>\n    <li>Provide prepaid return shipping label</li>\n    <li>Offer full refund including original shipping costs</li>\n    <li>Expedite processing of your case</li>\n</ul>\n\n<h2>International Returns</h2>\n<p>For international orders:</p>\n<ul>\n    <li>Return period extends to 45 days from delivery</li>\n    <li>Customer is responsible for return shipping costs</li>\n    <li>Customs duties and taxes are non-refundable</li>\n    <li>Refund processing may take 10-14 business days</li>\n</ul>\n\n<h2>Contact Us</h2>\n<p>For questions about returns or refunds:</p>\n\n<div style=\"display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; margin: 2rem 0;\">\n    <div style=\"text-align: center; padding: 2rem; background: white; border: 1px solid #e0e0e0;\">\n        <h4>Email</h4>\n        <p>returns@editionbypunjab.com</p>\n        <small>Response within 24 hours</small>\n    </div>\n    <div style=\"text-align: center; padding: 2rem; background: white; border: 1px solid #e0e0e0;\">\n        <h4>Phone</h4>\n        <p>+1 (555) 123-4567</p>\n        <small>Mon-Fri 9AM-6PM EST</small>\n    </div>\n    <div style=\"text-align: center; padding: 2rem; background: white; border: 1px solid #e0e0e0;\">\n        <h4>Live Chat</h4>\n        <p>Available on website</p>\n        <small>24/7 Support</small>\n    </div>\n</div>\n        ', 'Learn about our hassle-free return and refund process at Edition By Punjab', 1, '2025-09-05 13:00:59', '2025-09-05 13:00:59');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '0001_01_01_000000_create_users_table', 1),
(2, '0001_01_01_000001_create_cache_table', 1),
(3, '0001_01_01_000002_create_jobs_table', 1),
(4, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(5, '2024_01_01_000001_create_categories_table', 1),
(6, '2024_01_01_000002_create_products_table', 1),
(7, '2024_01_01_000003_create_inquiries_table', 1),
(8, '2024_01_01_000004_create_company_info_table', 1),
(9, '2024_01_01_000005_create_testimonials_table', 1),
(10, '2024_01_20_000001_create_carts_table', 1),
(11, '2024_01_20_000002_create_orders_table', 1),
(12, '2024_01_20_000003_create_order_items_table', 1),
(13, '2024_01_20_000004_create_shipping_addresses_table', 1),
(14, '2024_01_20_000005_create_wishlists_table', 1),
(15, '2024_01_20_000006_create_product_variants_table', 1),
(16, '2024_01_20_000007_create_coupons_table', 1),
(17, '2024_01_20_000008_add_shop_fields_to_products_table', 1),
(18, '2024_01_20_000009_add_shop_fields_to_company_info_table', 1),
(19, '2024_add_tracking_to_orders_table', 1),
(20, '2024_create_discount_campaigns_table', 1),
(21, '2024_create_newsletter_subscribers_table', 1),
(22, '2024_create_user_discounts_table', 1),
(23, '2025_08_20_062713_add_tracking_to_orders_table', 1),
(24, '2025_08_20_064539_add_tracking_to_orders_table', 1),
(25, '2024_add_missing_columns_to_categories_table', 2),
(26, '2024_create_banners_table', 3),
(27, '2024_create_instagram_feeds_table', 3),
(28, '2025_09_05_054413_create_blogs_table', 4),
(29, '2025_09_04_161302_create_legal_pages_table', 5),
(30, '2025_09_05_191004_create_community_posts_table', 6),
(31, '2025_09_06_060603_create_community_pages_table', 7),
(32, '2025_09_08_104340_create_style_guides_table', 8);

-- --------------------------------------------------------

--
-- Table structure for table `newsletter_subscribers`
--

CREATE TABLE `newsletter_subscribers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `discount_code` varchar(255) DEFAULT NULL,
  `discount_used` tinyint(1) NOT NULL DEFAULT 0,
  `subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `newsletter_subscribers`
--

INSERT INTO `newsletter_subscribers` (`id`, `email`, `name`, `is_active`, `discount_code`, `discount_used`, `subscribed_at`, `created_at`, `updated_at`) VALUES
(1, 'arriverrzenplay@gmail.com', NULL, 1, 'NEWSB47CF8', 0, '2025-09-06 13:28:22', '2025-09-06 13:28:22', '2025-09-06 13:28:22'),
(2, 'ahmed.mug03@gmail.com', NULL, 1, 'NEWS0D1721', 0, '2025-09-06 13:35:07', '2025-09-06 13:35:07', '2025-09-06 13:35:07');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_number` varchar(255) NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `customer_name` varchar(255) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `customer_phone` varchar(255) DEFAULT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `tax_amount` decimal(10,2) NOT NULL,
  `shipping_amount` decimal(10,2) NOT NULL,
  `shipping_method` varchar(255) DEFAULT NULL,
  `shipping_city` varchar(255) DEFAULT NULL,
  `shipping_state` varchar(255) DEFAULT NULL,
  `discount_amount` decimal(10,2) DEFAULT 0.00,
  `coupon_code` varchar(255) DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','shipped','delivered','cancelled') NOT NULL DEFAULT 'pending',
  `payment_status` enum('pending','paid','failed','refunded') NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `stripe_payment_intent` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `shipped_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_sku` varchar(255) DEFAULT NULL,
  `product_image` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(11) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) DEFAULT NULL,
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attributes`)),
  `product_options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`product_options`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `category_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `short_description` varchar(500) DEFAULT NULL,
  `specifications` text DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `compare_price` decimal(10,2) DEFAULT NULL,
  `cost_price` decimal(10,2) DEFAULT NULL,
  `stock` int(11) NOT NULL DEFAULT 0,
  `track_stock` tinyint(1) NOT NULL DEFAULT 1,
  `sku` varchar(255) DEFAULT NULL,
  `featured_image` varchar(255) DEFAULT NULL,
  `gallery_images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`gallery_images`)),
  `is_featured` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `views` int(11) NOT NULL DEFAULT 0,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keywords` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `weight` decimal(8,2) DEFAULT NULL,
  `dimensions` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `sizes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`sizes`)),
  `colors` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`colors`)),
  `sold_count` int(11) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `category_id`, `name`, `slug`, `description`, `short_description`, `specifications`, `price`, `compare_price`, `cost_price`, `stock`, `track_stock`, `sku`, `featured_image`, `gallery_images`, `is_featured`, `is_active`, `views`, `meta_title`, `meta_description`, `meta_keywords`, `created_at`, `updated_at`, `weight`, `dimensions`, `brand`, `sizes`, `colors`, `sold_count`) VALUES
(1, 1, 'Hoodie', 'hoodie', 'Hoodie for Sale for you.', 'Hoodie', NULL, 100.00, 110.00, 10.00, 10, 1, 'ARR-PF-001', 'products/1755800709_hoodie.jpg', '\"[\\\"products\\\\\\/gallery\\\\\\/1755800709_gallery_0_hoodie.jpg\\\",\\\"products\\\\\\/gallery\\\\\\/1755800709_gallery_1_hoodie.jpg\\\"]\"', 1, 1, 7, NULL, NULL, NULL, '2025-08-22 01:25:09', '2025-09-06 02:13:28', 1.00, '300x300', NULL, '\"[\\\"S\\\",\\\"M\\\",\\\"L\\\",\\\"XL\\\",\\\"XXL\\\"]\"', '\"[\\\"Black\\\",\\\"Blue\\\"]\"', 0),
(2, 1, 'New Test Product', 'new-test-product', 'saufhnsbsfhbsefhsjkzgfsafgksaflsdjfgbsdklfsadjkbsdjfvhbsdalbnksdfj', 'aisfjdsiafdufawuf', NULL, 100.00, 120.00, 10.00, 15, 1, 'ARR-PF-002', 'products/1755806834_new-test-product.jpg', '\"[\\\"products\\\\\\/gallery\\\\\\/1755806834_gallery_0_new-test-product.jpg\\\",\\\"products\\\\\\/gallery\\\\\\/1755806834_gallery_1_new-test-product.jpg\\\"]\"', 1, 1, 26, NULL, NULL, NULL, '2025-08-22 03:07:14', '2025-09-06 13:15:41', 1.00, '300x300', NULL, '\"[\\\"XS\\\",\\\"S\\\",\\\"M\\\",\\\"L\\\"]\"', '\"[\\\"Black\\\",\\\"Blue\\\"]\"', 0);

-- --------------------------------------------------------

--
-- Table structure for table `product_variants`
--

CREATE TABLE `product_variants` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `stock` int(11) NOT NULL DEFAULT 0,
  `price_adjustment` decimal(10,2) NOT NULL DEFAULT 0.00,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reviews`
--

CREATE TABLE `reviews` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `rating` int(11) NOT NULL DEFAULT 5,
  `title` varchar(255) DEFAULT NULL,
  `comment` text NOT NULL,
  `is_verified_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `is_approved` tinyint(1) NOT NULL DEFAULT 0,
  `helpful_count` int(11) NOT NULL DEFAULT 0,
  `not_helpful_count` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shipping_addresses`
--

CREATE TABLE `shipping_addresses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `address_line_1` varchar(255) NOT NULL,
  `address_line_2` varchar(255) DEFAULT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `postcode` varchar(255) NOT NULL,
  `postal_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) NOT NULL DEFAULT 'Australia',
  `is_default` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shipping_zones`
--

CREATE TABLE `shipping_zones` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `postcode_range` varchar(255) DEFAULT NULL,
  `standard_rate` decimal(10,2) DEFAULT 10.00,
  `express_rate` decimal(10,2) DEFAULT 15.00,
  `priority_rate` decimal(10,2) DEFAULT 25.00,
  `free_shipping_threshold` decimal(10,2) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `sort_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shipping_zones`
--

INSERT INTO `shipping_zones` (`id`, `city`, `state`, `postcode_range`, `standard_rate`, `express_rate`, `priority_rate`, `free_shipping_threshold`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES
(1, 'Other', 'ALL', NULL, 10.00, 15.00, 25.00, 100.00, 1, 0, '2025-08-30 07:08:32', '2025-08-30 07:08:32'),
(2, 'Malborne', 'ACT', NULL, 0.00, 0.00, 0.00, NULL, 1, 0, '2025-08-30 19:25:50', '2025-08-30 19:25:50'),
(3, 'Other', 'ALL', NULL, 10.00, 15.00, 25.00, 100.00, 1, 0, '2025-08-30 12:46:24', '2025-08-30 12:46:24');

-- --------------------------------------------------------

--
-- Table structure for table `style_guides`
--

CREATE TABLE `style_guides` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `tagline` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `region` varchar(255) NOT NULL,
  `population` varchar(255) NOT NULL,
  `fashion_score` int(11) NOT NULL,
  `streetwear_popularity` int(11) NOT NULL,
  `meta_title` text NOT NULL,
  `meta_description` text NOT NULL,
  `keywords` text NOT NULL,
  `climate` varchar(255) NOT NULL,
  `vibe` varchar(255) NOT NULL,
  `hero_image` varchar(255) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `styling_tips` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`styling_tips`)),
  `style_characteristics` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`style_characteristics`)),
  `key_pieces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`key_pieces`)),
  `seasonal_styling` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`seasonal_styling`)),
  `cultural_influences` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`cultural_influences`)),
  `color_palette` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`color_palette`)),
  `shopping_areas` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`shopping_areas`)),
  `weather` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`weather`)),
  `style_gallery` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`style_gallery`)),
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `style_guides`
--

INSERT INTO `style_guides` (`id`, `name`, `slug`, `tagline`, `description`, `region`, `population`, `fashion_score`, `streetwear_popularity`, `meta_title`, `meta_description`, `keywords`, `climate`, `vibe`, `hero_image`, `content`, `styling_tips`, `style_characteristics`, `key_pieces`, `seasonal_styling`, `cultural_influences`, `color_palette`, `shopping_areas`, `weather`, `style_gallery`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES
(1, 'Melbourne', 'melbourne', 'Creative Capital Style', 'Artistic, layered, and experimental fashion inspired by Melbourne\'s creative culture', 'Victoria', '5.2M', 9, 85, 'Melbourne Streetwear Style Guide | Creative Fashion Tips', 'Discover Melbourne streetwear style with our comprehensive guide. Artistic layering, vintage mixing, and creative fashion tips for Melbourne\'s unique style.', 'melbourne streetwear, melbourne fashion, creative style melbourne, australian streetwear melbourne, melbourne style guide', 'Variable - layers essential', 'Artistic, Creative, Experimental', 'style-guides/melbourne-hero.jpg', '<h2>Melbourne: Where Creativity Meets Street Style</h2>\n        \n        <p>Melbourne\'s fashion scene is as dynamic and unpredictable as its famous weather. The city\'s creative energy flows through its fashion choices, creating a unique style that celebrates artistic expression and individual creativity.</p>\n        \n        <h3>The Melbourne Aesthetic</h3>\n        \n        <div class=\"row\">\n            <div class=\"col-md-6\">\n                <h4>Layering Mastery</h4>\n                <p>Melbourne\'s \"four seasons in one day\" weather demands layering skills. Think lightweight cardigans over tees, denim jackets over hoodies, and accessories that can be added or removed as needed.</p>\n            </div>\n            <div class=\"col-md-6\">\n                <h4>Artistic Expression</h4>\n                <p>Melbourne streetwear embraces bold prints, unique silhouettes, and pieces that tell a story. It\'s not uncommon to see vintage band tees paired with contemporary tailoring.</p>\n            </div>\n        </div>\n        \n        <h3>Melbourne Street Style Essentials</h3>\n        \n        <ul>\n            <li><strong>The Perfect Hoodie:</strong> Oversized but not sloppy, in neutral or artistic prints</li>\n            <li><strong>Layering Pieces:</strong> Lightweight jackets, cardigans, and vests</li>\n            <li><strong>Statement Accessories:</strong> Unique jewelry, artistic bags, creative footwear</li>\n            <li><strong>All-Black Everything:</strong> Melbourne\'s unofficial uniform, always chic</li>\n        </ul>', '[\"Master the art of layering for Melbourne\'s unpredictable weather\",\"Mix vintage finds with contemporary pieces\",\"Embrace artistic prints and unique silhouettes\",\"Black is always a safe choice for Melbourne\'s creative scene\"]', '[{\"title\":\"All-Black Everything\",\"description\":\"Melbourne\'s unofficial uniform. Black provides the perfect canvas for creative expression.\"},{\"title\":\"Layering Mastery\",\"description\":\"Essential skill for Melbourne\'s \\\"four seasons in one day\\\" weather patterns.\"},{\"title\":\"Artistic Expression\",\"description\":\"Bold prints, unique silhouettes, and pieces that tell a creative story.\"}]', '[\"Oversized Hoodie\",\"Denim Jacket\",\"Black Skinny Jeans\",\"Statement Sneakers\",\"Artistic Tee\",\"Layering Cardigan\"]', '{\"spring\":{\"season\":\"Spring\",\"icon\":\"seedling\",\"description\":\"Light layers and transitional pieces\",\"tips\":[\"Denim jackets over hoodies\",\"Comfortable sneakers\",\"Light scarves for style\"]},\"summer\":{\"season\":\"Summer\",\"icon\":\"sun\",\"description\":\"Breathable fabrics with style\",\"tips\":[\"Cotton tees in artistic prints\",\"Lightweight fabrics\",\"Sun protection accessories\"]},\"autumn\":{\"season\":\"Autumn\",\"icon\":\"leaf\",\"description\":\"Perfect hoodie weather\",\"tips\":[\"Cozy textures\",\"Earth tones\",\"Layered looks\"]},\"winter\":{\"season\":\"Winter\",\"icon\":\"snowflake\",\"description\":\"Serious layering time\",\"tips\":[\"Heavy hoodies\",\"Thermal layers\",\"Statement outerwear\"]}}', '[{\"aspect\":\"Coffee Culture\",\"description\":\"Melbourne\'s cafe scene influences relaxed, artisanal fashion choices\"},{\"aspect\":\"Street Art\",\"description\":\"Vibrant laneways inspire bold graphics and artistic expression\"},{\"aspect\":\"Music Scene\",\"description\":\"Independent music culture drives authentic, non-conformist style choices\"}]', '[{\"name\":\"Melbourne Black\",\"hex\":\"#000000\"},{\"name\":\"Charcoal\",\"hex\":\"#36454F\"},{\"name\":\"Burgundy\",\"hex\":\"#800020\"},{\"name\":\"Forest Green\",\"hex\":\"#228B22\"}]', '[{\"name\":\"Chapel Street\",\"description\":\"Eclectic mix of vintage and contemporary streetwear\"},{\"name\":\"Fitzroy\",\"description\":\"Independent designers and unique boutiques\"},{\"name\":\"CBD Laneways\",\"description\":\"Hidden gems and emerging local brands\"}]', '{\"avg_temp\":\"15-20\\u00b0C\",\"rainfall\":\"Moderate, year-round\",\"best_months\":\"Mar-May, Sep-Nov\",\"style_note\":\"Always be prepared for sudden weather changes with versatile layers.\"}', '[{\"image\":\"gallery\\/melbourne-1.jpg\",\"description\":\"Classic Melbourne all-black\",\"style_type\":\"Minimalist\",\"alt_text\":\"Person wearing all-black Melbourne street style\"},{\"image\":\"gallery\\/melbourne-2.jpg\",\"description\":\"Artistic layering\",\"style_type\":\"Creative\",\"alt_text\":\"Creative layered outfit with artistic prints\"},{\"image\":\"gallery\\/melbourne-3.jpg\",\"description\":\"Street art inspired\",\"style_type\":\"Urban\",\"alt_text\":\"Urban street style inspired by Melbourne street art\"},{\"image\":\"gallery\\/melbourne-4.jpg\",\"description\":\"Coffee culture casual\",\"style_type\":\"Relaxed\",\"alt_text\":\"Relaxed casual outfit perfect for Melbourne cafe culture\"}]', 1, 1, '2025-09-08 18:01:21', '2025-09-08 18:01:21'),
(2, 'Sydney', 'sydney', 'Coastal Cool Vibes', 'Effortless beach-to-city style that embodies Sydney\'s relaxed sophistication', 'New South Wales', '5.3M', 8, 78, 'Sydney Streetwear Style Guide | Beach to City Fashion', 'Master Sydney streetwear style with our guide to coastal cool fashion. From beach to city, discover how to dress for Sydney\'s lifestyle.', 'sydney streetwear, sydney fashion, coastal fashion, beach style sydney, sydney style guide', 'Temperate - versatile pieces', 'Relaxed, Sophisticated, Coastal', 'style-guides/sydney-hero.jpg', '<h2>Sydney: Effortless Coastal Sophistication</h2>\n        \n        <p>Sydney style embodies the city\'s laid-back yet sophisticated lifestyle. It\'s about looking effortlessly put-together whether you\'re catching waves at Bondi or attending a rooftop bar in the CBD.</p>\n        \n        <h3>The Sydney Vibe</h3>\n        \n        <div class=\"row\">\n            <div class=\"col-md-6\">\n                <h4>Beach to City</h4>\n                <p>Sydney fashion is about versatility. Pieces need to work whether you\'re walking along the harbour or grabbing coffee in Surry Hills.</p>\n            </div>\n            <div class=\"col-md-6\">\n                <h4>Relaxed Sophistication</h4>\n                <p>Think elevated basics, quality fabrics, and timeless silhouettes that never try too hard but always look right.</p>\n            </div>\n        </div>\n        \n        <h3>Sydney Streetwear Staples</h3>\n        \n        <ul>\n            <li><strong>Quality Basics:</strong> Premium cotton tees and well-fitted hoodies</li>\n            <li><strong>Denim Done Right:</strong> Classic cuts in quality washes</li>\n            <li><strong>Versatile Footwear:</strong> Clean sneakers that work everywhere</li>\n            <li><strong>Sun-Smart Accessories:</strong> Stylish sunglasses and caps</li>\n        </ul>', '[\"Choose pieces that work from beach to boardroom\",\"Invest in quality basics in neutral tones\",\"Embrace the effortless sophistication Sydney is known for\",\"Don\'t forget sun protection - style and safety combined\"]', '[{\"title\":\"Beach to City\",\"description\":\"Versatile pieces that transition seamlessly from harbor walks to business meetings.\"},{\"title\":\"Quality Basics\",\"description\":\"Investment pieces in premium materials and timeless cuts.\"},{\"title\":\"Effortless Sophistication\",\"description\":\"Looking polished without trying too hard - the Sydney way.\"}]', '[\"Premium Cotton Tee\",\"Classic Denim\",\"Clean White Sneakers\",\"Light Jacket\",\"Quality Hoodie\",\"Sun-Smart Accessories\"]', '{\"spring\":{\"season\":\"Spring\",\"icon\":\"seedling\",\"description\":\"Perfect weather for layering\",\"tips\":[\"Light jackets for evening\",\"Breathable cottons\",\"Comfortable walking shoes\"]},\"summer\":{\"season\":\"Summer\",\"icon\":\"sun\",\"description\":\"Beach-ready with city polish\",\"tips\":[\"UV protection built-in\",\"Moisture-wicking fabrics\",\"Easy beach-to-bar transitions\"]},\"autumn\":{\"season\":\"Autumn\",\"icon\":\"leaf\",\"description\":\"Ideal conditions for streetwear\",\"tips\":[\"Perfect hoodie weather\",\"Layered textures\",\"Comfortable all-day wear\"]},\"winter\":{\"season\":\"Winter\",\"icon\":\"cloud-rain\",\"description\":\"Mild winter styling\",\"tips\":[\"Light layering sufficient\",\"Water-resistant pieces\",\"Versatile wardrobe staples\"]}}', '[{\"aspect\":\"Harbor Culture\",\"description\":\"Waterfront lifestyle inspires relaxed yet polished fashion choices\"},{\"aspect\":\"Beach Lifestyle\",\"description\":\"Coastal living demands versatile pieces that work for multiple occasions\"},{\"aspect\":\"Business District\",\"description\":\"CBD influence brings elevated basics and smart-casual elements\"}]', '[{\"name\":\"Ocean Blue\",\"hex\":\"#006994\"},{\"name\":\"Sand Beige\",\"hex\":\"#F5E6D3\"},{\"name\":\"Harbor Grey\",\"hex\":\"#708090\"},{\"name\":\"Sunset Orange\",\"hex\":\"#FF8C69\"}]', '[{\"name\":\"Surry Hills\",\"description\":\"Independent boutiques and creative streetwear brands\"},{\"name\":\"Newtown\",\"description\":\"Alternative fashion and vintage finds\"},{\"name\":\"Bondi Junction\",\"description\":\"Beach-to-city fashion and activewear specialists\"}]', '{\"avg_temp\":\"18-23\\u00b0C\",\"rainfall\":\"Moderate, winter peaks\",\"best_months\":\"Mar-May, Sep-Nov\",\"style_note\":\"Mild climate allows for year-round versatile styling with light layers.\"}', '[{\"image\":\"gallery\\/sydney-1.jpg\",\"description\":\"Beach to city transition\",\"style_type\":\"Versatile\",\"alt_text\":\"Versatile outfit transitioning from beach to city\"},{\"image\":\"gallery\\/sydney-2.jpg\",\"description\":\"Harbor walk ready\",\"style_type\":\"Casual\",\"alt_text\":\"Casual outfit perfect for Sydney harbor walks\"},{\"image\":\"gallery\\/sydney-3.jpg\",\"description\":\"Effortless sophistication\",\"style_type\":\"Smart-Casual\",\"alt_text\":\"Smart casual look embodying Sydney sophistication\"},{\"image\":\"gallery\\/sydney-4.jpg\",\"description\":\"Coastal cool vibes\",\"style_type\":\"Relaxed\",\"alt_text\":\"Relaxed coastal outfit with cool vibes\"}]', 1, 2, '2025-09-08 18:01:21', '2025-09-08 18:01:21'),
(3, 'Brisbane', 'brisbane', 'Tropical Streetwear', 'Breathable, bright, and bold fashion perfect for Queensland\'s sunny climate', 'Queensland', '2.6M', 7, 72, 'Brisbane Streetwear Style Guide | Tropical Fashion Tips', 'Navigate Brisbane\'s tropical climate with style. Our guide to breathable streetwear, bold colors, and comfortable fashion for Queensland living.', 'brisbane streetwear, brisbane fashion, tropical streetwear, queensland fashion, brisbane style guide', 'Subtropical - breathable fabrics', 'Relaxed, Colorful, Comfortable', 'style-guides/brisbane-hero.jpg', '<h2>Brisbane: Tropical Streetwear Done Right</h2>\n        \n        <p>Brisbane\'s subtropical climate demands smart fabric choices and breathable styling. The city\'s outdoor lifestyle and vibrant culture influence fashion choices that prioritize comfort without sacrificing style.</p>\n        \n        <h3>Climate-Smart Fashion</h3>\n        \n        <div class=\"row\">\n            <div class=\"col-md-6\">\n                <h4>Fabric Focus</h4>\n                <p>Cotton blends, linen, and moisture-wicking materials are essential. Avoid heavy fabrics that trap heat and humidity.</p>\n            </div>\n            <div class=\"col-md-6\">\n                <h4>Color Psychology</h4>\n                <p>Light colors reflect heat while bold tropical hues embrace Brisbane\'s vibrant outdoor culture.</p>\n            </div>\n        </div>\n        \n        <h3>Brisbane Style Essentials</h3>\n        \n        <ul>\n            <li><strong>Breathable Tees:</strong> Cotton and bamboo blends in light colors</li>\n            <li><strong>Lightweight Hoodies:</strong> For air-conditioned spaces and cooler evenings</li>\n            <li><strong>Comfortable Shorts:</strong> Quality cuts that look intentional, not sloppy</li>\n            <li><strong>Sun Protection:</strong> UPF clothing, wide-brim hats, and UV sunglasses</li>\n        </ul>', '[\"Prioritize breathable, moisture-wicking fabrics\",\"Don\'t shy away from bold tropical colors\",\"Lightweight layers for air-conditioned indoor spaces\",\"Comfortable footwear is essential for Brisbane\'s walking culture\"]', '[{\"title\":\"Climate-Smart\",\"description\":\"Breathable fabrics and UV protection built into everyday pieces.\"},{\"title\":\"Bold Colors\",\"description\":\"Tropical hues that reflect Queensland\'s vibrant outdoor lifestyle.\"},{\"title\":\"Comfort First\",\"description\":\"Functional fashion that works in heat and humidity.\"}]', '[\"Breathable Tee\",\"Lightweight Shorts\",\"UV-Protection Hoodie\",\"Comfortable Sneakers\",\"Sun Hat\",\"Quick-Dry Fabrics\"]', '{\"wet_season\":{\"season\":\"Wet Season\",\"icon\":\"cloud-rain\",\"description\":\"Nov-Apr: Hot and humid\",\"tips\":[\"Quick-dry fabrics\",\"Covered footwear\",\"Lightweight rain protection\"]},\"dry_season\":{\"season\":\"Dry Season\",\"icon\":\"sun\",\"description\":\"May-Oct: Perfect weather\",\"tips\":[\"Light layering possible\",\"Comfortable all-day wear\",\"Sun protection essential\"]}}', '[{\"aspect\":\"Outdoor Lifestyle\",\"description\":\"Year-round outdoor activities influence practical, comfortable fashion choices\"},{\"aspect\":\"River Culture\",\"description\":\"Brisbane River lifestyle promotes relaxed, water-friendly fashion\"},{\"aspect\":\"Subtropical Living\",\"description\":\"Hot climate demands breathable, functional yet stylish clothing\"}]', '[{\"name\":\"Tropical Coral\",\"hex\":\"#FF7F7F\"},{\"name\":\"Sunshine Yellow\",\"hex\":\"#FFD700\"},{\"name\":\"Palm Green\",\"hex\":\"#32CD32\"},{\"name\":\"Sky Blue\",\"hex\":\"#87CEEB\"}]', '[{\"name\":\"Fortitude Valley\",\"description\":\"Alternative fashion and streetwear boutiques\"},{\"name\":\"West End\",\"description\":\"Sustainable and locally-made fashion\"},{\"name\":\"Queen Street Mall\",\"description\":\"Mainstream and activewear brands\"}]', '{\"avg_temp\":\"20-28\\u00b0C\",\"rainfall\":\"High in summer, low in winter\",\"best_months\":\"Apr-Oct\",\"style_note\":\"Hot, humid summers require strategic fabric choices and breathable styling.\"}', '[{\"image\":\"gallery\\/brisbane-1.jpg\",\"description\":\"Tropical color blocking\",\"style_type\":\"Bold\",\"alt_text\":\"Bold tropical color blocking outfit\"},{\"image\":\"gallery\\/brisbane-2.jpg\",\"description\":\"Climate-smart casual\",\"style_type\":\"Practical\",\"alt_text\":\"Practical climate-smart casual wear\"},{\"image\":\"gallery\\/brisbane-3.jpg\",\"description\":\"River walk ready\",\"style_type\":\"Active\",\"alt_text\":\"Active wear perfect for Brisbane river walks\"},{\"image\":\"gallery\\/brisbane-4.jpg\",\"description\":\"Subtropical comfort\",\"style_type\":\"Relaxed\",\"alt_text\":\"Comfortable relaxed style for subtropical weather\"}]', 1, 3, '2025-09-08 18:01:21', '2025-09-08 18:01:21');

-- --------------------------------------------------------

--
-- Table structure for table `tax_rates`
--

CREATE TABLE `tax_rates` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `tax_name` varchar(255) DEFAULT 'GST',
  `rate` decimal(5,2) DEFAULT 10.00,
  `is_percentage` tinyint(1) DEFAULT 1,
  `is_active` tinyint(1) DEFAULT 1,
  `sort_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tax_rates`
--

INSERT INTO `tax_rates` (`id`, `city`, `state`, `tax_name`, `rate`, `is_percentage`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES
(1, 'Other', 'ALL', 'GST', 10.00, 1, 1, 0, '2025-08-30 07:08:32', '2025-08-30 07:08:32'),
(2, 'Malborne', 'ACT', 'GST', 0.00, 1, 1, 1, '2025-08-30 19:26:54', '2025-08-30 19:26:54'),
(3, 'Other', 'ALL', 'GST', 10.00, 1, 1, 0, '2025-08-30 12:46:24', '2025-08-30 12:46:24');

-- --------------------------------------------------------

--
-- Table structure for table `testimonials`
--

CREATE TABLE `testimonials` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `client_name` varchar(255) NOT NULL,
  `client_position` varchar(255) DEFAULT NULL,
  `client_company` varchar(255) DEFAULT NULL,
  `client_country` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `rating` int(11) NOT NULL DEFAULT 5,
  `client_image` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `is_blocked` tinyint(1) NOT NULL DEFAULT 0,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `phone`, `email_verified_at`, `password`, `is_admin`, `is_blocked`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Admin', 'admin@editionbypunjab.com', NULL, '2025-08-20 19:06:08', '$2y$12$8yVnNHoc2.DAHDAbPWXe.eHIe4sKvd.OFqO0luxOxCUngtalaEb.a', 1, 0, NULL, '2025-08-20 19:06:08', '2025-08-20 19:06:08'),
(2, 'Test Customer', 'customer@test.com', NULL, '2025-08-20 19:06:08', '$2y$12$.wFANkdIzq36VG12IHdnOe4kFAAfUfnxKG1CeD1OVpxPEsfrKrO4y', 0, 0, NULL, '2025-08-20 19:06:08', '2025-08-20 19:06:08'),
(3, 'Ahmed', 'ytrend203@gmail.com', NULL, '2025-08-26 10:04:44', '$2y$12$DPIG88wPwMkD5DVzegiUhOJ0gBalU1.gvK6mNxaZjD9N8lT4LTUp6', 0, 0, NULL, '2025-08-24 03:08:16', '2025-08-24 03:08:16'),
(4, 'Babar Ali', 'noshali2024@gmail.com', NULL, '2025-08-26 10:04:44', '$2y$12$pzSE0ZgTDBXnRVqcLDaJ2Os1IQFBx96X63L9h3iUX3GVikiZn1aQK', 0, 0, NULL, '2025-08-25 12:07:50', '2025-08-25 12:07:50'),
(5, 'Ahmed Raza', 'ahmedtechinstitute@gmail.com', NULL, NULL, '$2y$12$9/CnYwJ9ny9SgDtVCMReGeFH4h3cRSkYAFhYhyabKsVGAsezOXKe2', 0, 0, NULL, '2025-08-26 17:12:40', '2025-08-26 17:12:40');

-- --------------------------------------------------------

--
-- Table structure for table `user_discounts`
--

CREATE TABLE `user_discounts` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `discount_code` varchar(255) NOT NULL,
  `discount_percentage` decimal(5,2) NOT NULL,
  `discount_type` enum('percentage','fixed') NOT NULL,
  `is_used` tinyint(1) NOT NULL DEFAULT 0,
  `used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `user_discounts`
--

INSERT INTO `user_discounts` (`id`, `user_id`, `email`, `discount_code`, `discount_percentage`, `discount_type`, `is_used`, `used_at`, `expires_at`, `created_at`, `updated_at`) VALUES
(1, 3, 'arriverrzenplay@gmail.com', 'NEWSB47CF8', 10.00, 'percentage', 0, NULL, '2025-10-06 13:28:22', '2025-09-06 13:28:22', '2025-09-06 13:28:22'),
(2, 3, 'ahmed.mug03@gmail.com', 'NEWS0D1721', 10.00, 'percentage', 0, NULL, '2025-10-06 13:35:07', '2025-09-06 13:35:07', '2025-09-06 13:35:07');

-- --------------------------------------------------------

--
-- Table structure for table `wishlists`
--

CREATE TABLE `wishlists` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `product_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `wishlists`
--

INSERT INTO `wishlists` (`id`, `user_id`, `product_id`, `created_at`, `updated_at`) VALUES
(1, 1, 2, '2025-08-22 03:08:33', '2025-08-22 03:08:33');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `banners`
--
ALTER TABLE `banners`
  ADD PRIMARY KEY (`id`),
  ADD KEY `banners_position_is_active_index` (`position`,`is_active`);

--
-- Indexes for table `blogs`
--
ALTER TABLE `blogs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `blogs_slug_unique` (`slug`),
  ADD KEY `blogs_is_published_published_at_index` (`is_published`,`published_at`),
  ADD KEY `blogs_slug_index` (`slug`),
  ADD KEY `blogs_is_featured_index` (`is_featured`);

--
-- Indexes for table `cache`
--
ALTER TABLE `cache`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `cache_locks`
--
ALTER TABLE `cache_locks`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `carts`
--
ALTER TABLE `carts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `carts_user_id_foreign` (`user_id`),
  ADD KEY `carts_product_id_foreign` (`product_id`),
  ADD KEY `carts_session_id_user_id_index` (`session_id`,`user_id`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `categories_slug_unique` (`slug`),
  ADD KEY `idx_parent_id` (`parent_id`),
  ADD KEY `idx_sort_order` (`sort_order`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_slug` (`slug`);

--
-- Indexes for table `community_pages`
--
ALTER TABLE `community_pages`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `community_pages_page_key_unique` (`page_key`);

--
-- Indexes for table `community_posts`
--
ALTER TABLE `community_posts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `community_posts_status_approved_at_index` (`status`,`approved_at`),
  ADD KEY `community_posts_featured_status_index` (`featured`,`status`);

--
-- Indexes for table `company_info`
--
ALTER TABLE `company_info`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `coupons`
--
ALTER TABLE `coupons`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `coupons_code_unique` (`code`),
  ADD KEY `idx_coupons_code_is_active` (`code`,`is_active`),
  ADD KEY `idx_coupons_valid_from_valid_until` (`valid_from`,`valid_until`);

--
-- Indexes for table `discount_campaigns`
--
ALTER TABLE `discount_campaigns`
  ADD PRIMARY KEY (`id`),
  ADD KEY `discount_campaigns_starts_at_ends_at_index` (`starts_at`,`ends_at`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `inquiries`
--
ALTER TABLE `inquiries`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inquiries_product_id_foreign` (`product_id`);

--
-- Indexes for table `instagram_feeds`
--
ALTER TABLE `instagram_feeds`
  ADD PRIMARY KEY (`id`),
  ADD KEY `instagram_feeds_is_active_index` (`is_active`);

--
-- Indexes for table `jobs`
--
ALTER TABLE `jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jobs_queue_index` (`queue`);

--
-- Indexes for table `job_batches`
--
ALTER TABLE `job_batches`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `legal_pages`
--
ALTER TABLE `legal_pages`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `legal_pages_slug_unique` (`slug`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `newsletter_subscribers`
--
ALTER TABLE `newsletter_subscribers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `newsletter_subscribers_email_unique` (`email`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `orders_order_number_unique` (`order_number`),
  ADD KEY `orders_user_id_foreign` (`user_id`),
  ADD KEY `idx_shipping_location` (`shipping_city`,`shipping_state`),
  ADD KEY `idx_coupon_code` (`coupon_code`),
  ADD KEY `idx_stripe_payment` (`stripe_payment_intent`),
  ADD KEY `orders_shipping_city_shipping_state_index` (`shipping_city`,`shipping_state`),
  ADD KEY `orders_coupon_code_index` (`coupon_code`),
  ADD KEY `orders_stripe_payment_intent_index` (`stripe_payment_intent`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_items_order_id_foreign` (`order_id`),
  ADD KEY `order_items_product_id_foreign` (`product_id`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `products_slug_unique` (`slug`),
  ADD UNIQUE KEY `products_sku_unique` (`sku`),
  ADD KEY `products_category_id_foreign` (`category_id`),
  ADD KEY `idx_featured` (`is_featured`),
  ADD KEY `idx_active` (`is_active`),
  ADD KEY `idx_stock` (`stock`),
  ADD KEY `idx_views` (`views`);

--
-- Indexes for table `product_variants`
--
ALTER TABLE `product_variants`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_variants_product_id_foreign` (`product_id`);

--
-- Indexes for table `reviews`
--
ALTER TABLE `reviews`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_reviews_product_id_is_approved` (`product_id`,`is_approved`),
  ADD KEY `idx_reviews_user_id_is_approved` (`user_id`,`is_approved`),
  ADD KEY `idx_reviews_rating` (`rating`);

--
-- Indexes for table `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sessions_user_id_index` (`user_id`),
  ADD KEY `sessions_last_activity_index` (`last_activity`);

--
-- Indexes for table `shipping_addresses`
--
ALTER TABLE `shipping_addresses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `shipping_addresses_order_id_foreign` (`order_id`),
  ADD KEY `fk_shipping_user_id` (`user_id`);

--
-- Indexes for table `shipping_zones`
--
ALTER TABLE `shipping_zones`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_city_state` (`city`,`state`),
  ADD KEY `idx_active` (`is_active`);

--
-- Indexes for table `style_guides`
--
ALTER TABLE `style_guides`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `style_guides_slug_unique` (`slug`);

--
-- Indexes for table `tax_rates`
--
ALTER TABLE `tax_rates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_city_state` (`city`,`state`),
  ADD KEY `idx_active` (`is_active`);

--
-- Indexes for table `testimonials`
--
ALTER TABLE `testimonials`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_is_admin_index` (`is_admin`);

--
-- Indexes for table `user_discounts`
--
ALTER TABLE `user_discounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `user_discounts_discount_code_unique` (`discount_code`),
  ADD KEY `user_discounts_user_id_foreign` (`user_id`),
  ADD KEY `user_discounts_email_index` (`email`),
  ADD KEY `user_discounts_discount_code_index` (`discount_code`);

--
-- Indexes for table `wishlists`
--
ALTER TABLE `wishlists`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `wishlists_user_id_product_id_unique` (`user_id`,`product_id`),
  ADD KEY `wishlists_product_id_foreign` (`product_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `banners`
--
ALTER TABLE `banners`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `blogs`
--
ALTER TABLE `blogs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `carts`
--
ALTER TABLE `carts`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `community_pages`
--
ALTER TABLE `community_pages`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `community_posts`
--
ALTER TABLE `community_posts`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `company_info`
--
ALTER TABLE `company_info`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `coupons`
--
ALTER TABLE `coupons`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `discount_campaigns`
--
ALTER TABLE `discount_campaigns`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inquiries`
--
ALTER TABLE `inquiries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `instagram_feeds`
--
ALTER TABLE `instagram_feeds`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `jobs`
--
ALTER TABLE `jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `legal_pages`
--
ALTER TABLE `legal_pages`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=33;

--
-- AUTO_INCREMENT for table `newsletter_subscribers`
--
ALTER TABLE `newsletter_subscribers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `product_variants`
--
ALTER TABLE `product_variants`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `reviews`
--
ALTER TABLE `reviews`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `shipping_addresses`
--
ALTER TABLE `shipping_addresses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `shipping_zones`
--
ALTER TABLE `shipping_zones`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `style_guides`
--
ALTER TABLE `style_guides`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `tax_rates`
--
ALTER TABLE `tax_rates`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `testimonials`
--
ALTER TABLE `testimonials`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `user_discounts`
--
ALTER TABLE `user_discounts`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `wishlists`
--
ALTER TABLE `wishlists`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `carts`
--
ALTER TABLE `carts`
  ADD CONSTRAINT `carts_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `carts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `fk_categories_parent` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `inquiries`
--
ALTER TABLE `inquiries`
  ADD CONSTRAINT `inquiries_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`);

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `product_variants`
--
ALTER TABLE `product_variants`
  ADD CONSTRAINT `product_variants_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `reviews`
--
ALTER TABLE `reviews`
  ADD CONSTRAINT `fk_reviews_product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_reviews_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `shipping_addresses`
--
ALTER TABLE `shipping_addresses`
  ADD CONSTRAINT `fk_shipping_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `shipping_addresses_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `shipping_addresses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `user_discounts`
--
ALTER TABLE `user_discounts`
  ADD CONSTRAINT `user_discounts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wishlists`
--
ALTER TABLE `wishlists`
  ADD CONSTRAINT `wishlists_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wishlists_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
